% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diagnostics.R
\name{checkTimeStabilityAssumption}
\alias{checkTimeStabilityAssumption}
\title{Check stability of outcome rate over time}
\usage{
checkTimeStabilityAssumption(
  studyPopulation,
  sccsModel = NULL,
  maxRatio = 1.1,
  alpha = 0.05
)
}
\arguments{
\item{studyPopulation}{An object created using the \code{\link[=createStudyPopulation]{createStudyPopulation()}} function.}

\item{sccsModel}{Optional: A fitted SCCS model as created using \code{\link[=fitSccsModel]{fitSccsModel()}}. If the
model contains splines for seasonality and or calendar time these will be adjusted
for before computing stability.}

\item{maxRatio}{The maximum global ratio between the observed and expected count.}

\item{alpha}{The alpha (type 1 error) used to test for stability.}
}
\value{
A tibble with one row and three columns: \code{ratio} indicates the estimated mean ratio between observed and expected.
\code{p} is the p-value against the null-hypothesis that the ratio is smaller than \code{maxRatio}, and \code{pass} is \code{TRUE}
if \code{p} is greater than \code{alpha}.
}
\description{
Check stability of outcome rate over time
}
\details{
Computes for each month the observed and expected count, and computes the (weighted) mean ratio between the two. If
splines are used to adjust for seasonality and/or calendar time, these adjustments are taken into consideration when
considering the expected count. A one-sided p-value is computed against the null hypothesis that the ratio is smaller
than \code{maxRatio}. If this p-value exceeds the specified alpha value, the series is considered stable.
}
