% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMFG.R
\name{TMFG}
\alias{TMFG}
\title{Triangulated Maximally Filtered Graph}
\usage{
TMFG(data, depend = FALSE)
}
\arguments{
\item{data}{Matrix or data frame.
Must be a square matrix}

\item{depend}{Boolean.
Is network a dependency (or directed) network?
Defaults to \code{FALSE}.
Set to \code{TRUE} to generate a TMFG-filtered dependency network
(output obtained from the \code{\link[NetworkToolbox]{depend}} function)}
}
\value{
Returns an TMFG filtered adjacency matrix
}
\description{
Applies the Triangulated Maximally Filtered Graph (TMFG) filtering method
(\strong{Please see and cite Massara et al., 2016}). The TMFG method uses a structural
constraint that limits the number of zero-order correlations included in the network
(3n - 6; where \emph{n} is the number of variables). The TMFG algorithm begins by
identifying four variables which have the largest sum of correlations to all other
variables. Then, it iteratively adds each variable with the largest sum of three
correlations to nodes already in the network until all variables have been added to
the network. This structure can be associated with the inverse correlation matrix
(i.e., precision matrix) to be turned into a GGM (i.e., partial correlation network)
by using \code{\link[NetworkToolbox]{LoGo}}. See Details for more information on this
network estimation method.
}
\details{
The TMFG method applies a structural constraint on the network,
which restrains the network to retain a certain number of edges (3\emph{n}-6, where \emph{n}
is the number of nodes; Massara et al., 2016). The network is also composed of 3- and 4-node
cliques (i.e., sets of connected nodes; a triangle and tetrahedron, respectively). The
TMFG method constructs a network using zero-order correlations and the resulting network
can be associated with the inverse covariance matrix
(yielding a GGM; Barfuss, Massara, Di Matteo, & Aste, 2016).
Notably, the TMFG can use any association measure and thus does not assume the data is multivariate normal.

Construction begins by forming a tetrahedron of the four nodes that have
the highest sum of correlations that are greater than the average correlation in the
correlation matrix. Next, the algorithm iteratively identifies the node that maximizes
its sum of correlations to a connected set of three nodes (triangles) already included
in the network and then adds that node to the network. The process is completed once
every node is connected in the network. In this process, the network automatically
generates what's called a planar network. A planar network is a network that could be
drawn on a sphere with no edges crossing (often, however, the networks are depicted
with edges crossing; Tumminello, Aste, Di Matteo, & Mantegna, 2005).
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(similarity(sim.fluency(100), method = "cor"))

}
\references{
Christensen, A. P., Kenett, Y. N., Aste, T., Silvia, P. J., & Kwapil, T. R. (2018).
Network structure of the Wisconsin Schizotypy Scales-Short Forms: Examining psychometric network filtering approaches.
\emph{Behavior Research Methods}, \emph{50}, 2531-2550.

Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Network filtering for big data: Triangulated maximally filtered graph.
\emph{Journal of Complex Networks}, \emph{5}, 161-178.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
