% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randwalk.R
\name{randwalk}
\alias{randwalk}
\title{Random Walk Simulation}
\usage{
randwalk(A, B, reps = 20, steps = 10, iter = 10000, cores)
}
\arguments{
\item{A}{Matrix or data frame.
Adjacency matrix of a semantic network}

\item{B}{Matrix or data frame.
A comparison adjacency matrix of a semantic network}

\item{reps}{Numeric.
Number of repetitions of increments in 10 steps.
Defaults to \code{20}}

\item{steps}{Numeric.
Number of random steps to begin with.
Defaults to \code{10}}

\item{iter}{Numeric.
Number of iterations for each random walk.
Defaults to \code{10000}}

\item{cores}{Numeric.
Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maximum amount of cores on your computer}
}
\value{
A result matrix containing the means and standard deviations for
several measures as well as \emph{p}-values for a Mann-Whitney U test
}
\description{
Simulates random walks over two networks to examine the characteristics
of spontaneous spreading activation (see Kenett & Austerweil, 2016)
}
\examples{
# Simulate Datasets
one <- sim.fluency(10)
two <- sim.fluency(10)

# Compute similarity matrix
cos1 <- similarity(one, method = "cosine")
cos2 <- similarity(two, method = "cosine")

# Compute networks
net1 <- TMFG(cos1)
net2 <- TMFG(cos2)
\donttest{
# Run random walk analysis
rw.results <- randwalk(net1, net2, iter = 100, cores = 2)
}
\dontshow{rw.results <- randwalk(net1, net2, iter = 10, cores = 2)}

}
\references{
Kenett, Y. N., & Austerweil, J. L. (2016).
Examining search processes in low and high creative individuals with random walks.
In \emph{Paper presented at the proceedings of the 38th annual meeting of the cognitive science society}. Austin, TX.
Retrieved from: \href{http://alab.psych.wisc.edu/papers/files/Kenett16CreativityRW.pdf}{http://alab.psych.wisc.edu/papers/files/Kenett16CreativityRW.pdf}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com> and Yoed Kenett <yoedkenett@gmail.com>
}
