% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensusR.R
\name{sensus.plot.lag.cdf}
\alias{sensus.plot.lag.cdf}
\title{Plot the CDF of inter-reading time lags.}
\usage{
sensus.plot.lag.cdf(datum, xlim = c(0, 1),
  xlab = "Inter-reading time (seconds)", ylab = "Percentile",
  main = paste("Inter-reading times (n=", nrow(datum), ")", sep = ""))
}
\arguments{
\item{datum}{Data frame for a single datum.}

\item{xlim}{Limits for the x-axis.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{main}{Label for plot.}
}
\description{
Plot the CDF of inter-reading time lags.
}
\examples{
data.path = system.file("extdata", "example-data", package="SensusR")
data = sensus.read.json.files(data.path)
sensus.plot.lag.cdf(data$AccelerometerDatum)
}
