% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotSentimentResponse}
\alias{plotSentimentResponse}
\title{Scatterplot with trend line between sentiment and response}
\usage{
plotSentimentResponse(
  sentiment,
  response,
  smoothing = "gam",
  xlab = "Sentiment",
  ylab = "Response"
)
}
\arguments{
\item{sentiment}{\code{data.frame} with sentiment scores}

\item{response}{Vector with response variables of the same length}

\item{smoothing}{Smoothing functionality. Default is \code{smoothing="gam"}
to utilize a generalized additive model (GAM). Other options can be e.g.
a linear trend line (\code{smoothing="lm"}); see \code{\link[ggplot2]{geom_smooth}}
for a full list of options.}

\item{xlab}{Description on x-axis (default: "Sentiment").}

\item{ylab}{Description on y-axis (default: "Sentiment").}
}
\value{
Returns a plot of class \code{\link[ggplot2]{ggplot}}
}
\description{
Generates a scatterplot where points pairs of sentiment and
the response variable. In addition, the plot addas a trend line
in the form of a generalized additive model (GAM). Other
smoothing variables are possible based on \code{\link[ggplot2]{geom_smooth}}.
This functions is helpful for visualization the relationship
between computed sentiment scores and the gold standard.
}
\examples{
sentiment <- data.frame(Dictionary=runif(10))
response <- sentiment[[1]] + rnorm(10)

plotSentimentResponse(sentiment, response)

# Change x-axis
plotSentimentResponse(sentiment, response, xlab="Tone")

library(ggplot2)
# Extend plot with additional layout options
plotSentimentResponse(sentiment, response) + ggtitle("Scatterplot")
plotSentimentResponse(sentiment, response) + theme_void() 
}
\seealso{
\code{\link{plotSentiment}} and \code{\link{plot.SentimentDictionaryWeighted}} for further plotting options
}
\keyword{evaluation}
\keyword{plots}
