% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{SCTransform}
\alias{SCTransform}
\title{Use regularized negative binomial regression to normalize UMI count data}
\usage{
SCTransform(object, assay = "RNA", new.assay.name = "SCT",
  do.correct.umi = TRUE, variable.features.n = 3000,
  variable.features.rv.th = 1.3, vars.to.regress = NULL,
  do.scale = FALSE, do.center = TRUE, clip.range = c(-sqrt(x = ncol(x
  = object[[assay]])/30), sqrt(x = ncol(x = object[[assay]])/30)),
  conserve.memory = FALSE, return.only.var.genes = TRUE,
  seed.use = 1448145, verbose = TRUE, ...)
}
\arguments{
\item{object}{A seurat object}

\item{assay}{Name of assay to pull the count data from; default is 'RNA'}

\item{new.assay.name}{Name for the new assay containing the normalized data}

\item{do.correct.umi}{Place corrected UMI matrix in assay counts slot; default is TRUE}

\item{variable.features.n}{Use this many features as variable features after
ranking by residual variance; default is 3000}

\item{variable.features.rv.th}{Instead of setting a fixed number of variable features,
use this residual variance cutoff; this is only used when \code{variable.features.n}
is set to NULL; default is 1.3}

\item{vars.to.regress}{Variables to regress out in a second non-regularized linear
regression. For example, percent.mito. Default is NULL}

\item{do.scale}{Whether to scale residuals to have unit variance; default is FALSE}

\item{do.center}{Whether to center residuals to have mean zero; default is TRUE}

\item{clip.range}{Range to clip the residuals to; default is \code{c(-sqrt(n/30), sqrt(n/30))},
where n is the number of cells}

\item{conserve.memory}{If set to TRUE the residual matrix for all genes is never
created in full; useful for large data sets, but will take longer to run;
this will also set return.only.var.genes to TRUE; default is FALSE}

\item{return.only.var.genes}{If set to TRUE the scale.data matrices in output assay are
subset to contain only the variable genes; default is FALSE}

\item{seed.use}{Set a random seed. By default, sets the seed to 1448145. Setting
NULL will not set a seed.}

\item{verbose}{Whether to print messages and progress bars}

\item{...}{Additional parameters passed to \code{sctransform::vst}}
}
\value{
Returns a Seurat object with a new assay (named SCT by default) with 
counts being (corrected) counts, data being log1p(counts), scale.data being 
pearson residuals; sctransform::vst intermediate results are saved in misc 
slot of the new assay.
}
\description{
This function calls sctransform::vst. The sctransform package is available at
https://github.com/ChristophH/sctransform.
Use this function as an alternative to the NormalizeData,
FindVariableFeatures, ScaleData workflow. Results are saved in a new assay
(named SCT by default) with counts being (corrected) counts, data being log1p(counts),
scale.data being pearson residuals; sctransform::vst intermediate results are saved
in misc slot of new assay.
}
\examples{
SCTransform(object = pbmc_small)

}
