% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{TransferData}
\alias{TransferData}
\title{Transfer Labels}
\usage{
TransferData(
  anchorset,
  refdata,
  weight.reduction = "pcaproject",
  l2.norm = FALSE,
  dims = 1:30,
  k.weight = 50,
  sd.weight = 1,
  eps = 0,
  do.cpp = TRUE,
  verbose = TRUE,
  slot = "data"
)
}
\arguments{
\item{anchorset}{Results from FindTransferAnchors}

\item{refdata}{Data to transfer. Should be either a vector where the names
correspond to reference cells, or a matrix, where the column names correspond
to the reference cells.}

\item{weight.reduction}{Dimensional reduction to use for the weighting.
Options are:
\itemize{
   \item{pcaproject: Use the projected PCA used for anchor building}
   \item{pca: Use an internal PCA on the query only}
   \item{cca: Use the CCA used for anchor building}
   \item{custom DimReduc: User provided DimReduc object computed on the query
   cells}
}}

\item{l2.norm}{Perform L2 normalization on the cell embeddings after
dimensional reduction}

\item{dims}{Number of PCs to use in the weighting procedure}

\item{k.weight}{Number of neighbors to consider when weighting}

\item{sd.weight}{Controls the bandwidth of the Gaussian kernel for weighting}

\item{eps}{Error bound on the neighbor finding algorithm (from RANN)}

\item{do.cpp}{Run cpp code where applicable}

\item{verbose}{Print progress bars and output}

\item{slot}{Slot to store the imputed data}
}
\value{
If refdata is a vector, returns a dataframe with label predictions.
If refdata is a matrix, returns an Assay object where the imputed data has
been stored in the provided slot.
}
\description{
Transfers the labels
}
