% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CellSelector}
\alias{CellSelector}
\alias{FeatureLocator}
\title{Cell Selector}
\usage{
CellSelector(plot, object = NULL, ident = "SelectedCells", ...)

FeatureLocator(plot, ...)
}
\arguments{
\item{plot}{A ggplot2 plot}

\item{object}{An optional Seurat object; if passes, will return an object
with the identities of selected cells set to \code{ident}}

\item{ident}{An optional new identity class to assign the selected cells}

\item{...}{Ignored}
}
\value{
If \code{object} is \code{NULL}, the names of the points selected;
otherwise, a Seurat object with the selected cells identity classes set to
\code{ident}
}
\description{
Select points on a scatterplot and get information about them
}
\examples{
\dontrun{
plot <- DimPlot(object = pbmc_small)
# Follow instructions in the terminal to select points
cells.located <- CellSelector(plot = plot)
cells.located
# Automatically set the identity class of selected cells and return a new Seurat object
pbmc_small <- CellSelector(plot = plot, object = pbmc_small, ident = 'SelectedCells')
}

}
\seealso{
\code{\link{DimPlot}} \code{\link{FeaturePlot}}
}
