% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimensional_reduction.R
\name{RunICA}
\alias{RunICA}
\alias{RunICA.default}
\alias{RunICA.Assay}
\alias{RunICA.Seurat}
\title{Run Independent Component Analysis on gene expression}
\usage{
RunICA(object, ...)

\method{RunICA}{default}(
  object,
  assay = NULL,
  nics = 50,
  rev.ica = FALSE,
  ica.function = "icafast",
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.name = "ica",
  reduction.key = "ica_",
  seed.use = 42,
  ...
)

\method{RunICA}{Assay}(
  object,
  assay = NULL,
  features = NULL,
  nics = 50,
  rev.ica = FALSE,
  ica.function = "icafast",
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.name = "ica",
  reduction.key = "ica_",
  seed.use = 42,
  ...
)

\method{RunICA}{Seurat}(
  object,
  assay = NULL,
  features = NULL,
  nics = 50,
  rev.ica = FALSE,
  ica.function = "icafast",
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.name = "ica",
  reduction.key = "IC_",
  seed.use = 42,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{\dots}{Additional arguments to be passed to fastica}

\item{assay}{Name of Assay ICA is being run on}

\item{nics}{Number of ICs to compute}

\item{rev.ica}{By default, computes the dimensional reduction on the cell x
feature matrix. Setting to true will compute it on the transpose (feature x cell
matrix).}

\item{ica.function}{ICA function from ica package to run (options: icafast,
icaimax, icajade)}

\item{verbose}{Print the top genes associated with high/low loadings for
the ICs}

\item{ndims.print}{ICs to print genes for}

\item{nfeatures.print}{Number of genes to print for each IC}

\item{reduction.name}{dimensional reduction name}

\item{reduction.key}{dimensional reduction key, specifies the string before
the number for the dimension names.}

\item{seed.use}{Set a random seed.  Setting NULL will not set a seed.}

\item{features}{Features to compute ICA on}
}
\description{
Run fastica algorithm from the ica package for ICA dimensionality reduction.
For details about stored ICA calculation parameters, see
\code{PrintICAParams}.
}
\concept{dimensional_reduction}
