% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_curve.r
\name{temperature_curve}
\alias{temperature_curve}
\title{Function that creates a sinusoidal Sea Surface Temperature (SST) curve
from a list of parameters}
\usage{
temperature_curve(T_par, years = 1, t_int = 1)
}
\arguments{
\item{T_par}{List of four parameters describing (in order) amplitude
(\code{T_amp}; in degrees C), period (\code{T_per}; in days), phase
(\code{T_pha} in day of the year) and average temperature (\code{T_av};
in degrees C)}

\item{years}{Length of the preferred sinusoid in number of years (defaults
to 1)}

\item{t_int}{Time interval of sinusoidal record (in days)}
}
\value{
A matrix containing columns for time (in days) and SST (in degrees C)
}
\description{
Takes the specified parameters for amplitude, period, phase and average value
as well as the number of years specified and the time interval. It then
creates a sinusoid based on the boundary conditions. Used as intermediate
step during iterative modelling.
}
\examples{
# Set parameters
T_amp <- 20
T_per <- 365
T_pha <- 150
T_av <- 15
T_par <- c(T_amp, T_per, T_pha, T_av)
SST <- temperature_curve(T_par, 1, 1) # Run the function
}
