% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagehistory.R
\docType{class}
\name{siaction}
\alias{siaction}
\title{Class providing object describing one action.}
\format{\code{\link{R6Class}} object.}
\usage{
siaction
}
\value{
Object of \code{\link{R6Class}} representing a single ShinyImage action.
}
\description{
Class providing object describing one action.
}
\section{Fields}{

\describe{
\item{\code{brightness}}{Stores address of your lightning server.}

\item{\code{contrast}}{Stores id of your current session on the server.}

\item{\code{gamma}}{Stores url of the last visualization created by this object.}

\item{\code{crop}}{A double nested sequence of crops c(c(x1, y1), c(x2, y2)).}

\item{\code{blur}}{stores value of blur}

\item{\code{rotate}}{stores value of rotate}

\item{\code{grayscale}}{stores value of colormode (1 if grayscale, 0 if color)
#' @section Methods:
\describe{
\item{Documentation}{The user should not need to create an action object. This is a class used exclusively by a shinyimg to keep track of a set of changes.}
\item{\code{new(brightness, contrast, gamma, crop)}}{This method is used to create object of this class with the appropriate parameters.}

\item{\code{get_action()}}{This method returns a c() list of the input parameters.}
}}
}}

\examples{
crop = c(c(0, 0), c(1200, 1400))
siaction$new(0.1, 1, 0, crop, 1, 0, 0)
}
\keyword{data}
