library(shiny)

if (interactive()) {

  ui <- fluidPage(
    h3("Settings of report"),
    p(code("ShinyItemAnalysis"), " offers an option to download a report in HTML or PDF format.
      PDF report local creation requires latest version of", a("MiKTeX", href = "https://miktex.org/howto/install-miktex", target = "_blank"),
      "(or other TeX distribution). MiKTex and PDF report creation are available at online version of app. If you don't have
      the latest installation, please, use the HTML report."),
    p("There is an option whether to use customize settings. By checking the", strong("Customize settings"),
      "local settings will be offered and use for each selected section of report. You can then also add/remove/edit text in reports
      through text areas. Otherwise the settings will be taken from pages of application.
      You can also include your name into report as well as the name of dataset which was used. "),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  radioButtons(inputId = "report_format",
                               label = "Format of report",
                               choices = c("HTML" = "html", "PDF" = "pdf"))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  checkboxInput(inputId = "report_customize",
                                label = "Customize settings",
                                value = FALSE))),
    #------------------------------------------------------------------------------------
    #------------------------------------------------------------------------------------
    h3("Content of report"),
    #------------------------------------------------------------------------------------
    h4("Header"),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  textInput(inputId = "report_author",
                            label = "Author")),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  textInput(inputId = "report_dataset",
                            label = "Dataset"))),
    # NOTE: for text areas the heights is number of rows*20px + 15px
    #------------------------------------------------------------------------------------
    h4("Summary"),
    h5("Total scores"),
    # table of total scores
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  checkboxInput(inputId = "report_totalscores_table",
                                label = "Summary table of total scores",
                                value = T)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_totalscores_table",
                                                    textAreaInput(inputId = "report_totalscores_table_text",
                                                                  label = "Text area",
                                                                  value = "Table below summarizes basic characteristics of total scores including minimum and maximum, mean, median, standard deviation, skewness and kurtosis. The kurtosis here is estimated by sample kurtosis \\(\\frac{m_4}{m_2^2}\\), where \\(m_4\\) is the fourth sample moment about the mean and \\(m_2\\) is the second sample moment about the mean. The skewness is estimated by sample skewness \\(\\frac{m_3}{m_2^{3/2}}\\), where \\(m_3\\) is the third sample moment about the mean. The kurtosis for normally distributed scores is near the value of 3 and the skewness is near the value of 0. ",
                                                                  width = "700px", height = "135px"))))),
    # histogram of total scores
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  checkboxInput(inputId = "report_totalscores_histogram",
                                label = "Histogram of total scores",
                                value = T)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_totalscores_histogram",
                                                    numericInput(inputId = "report_totalscores_histogram_cutscore",
                                                                 label = "Cut score",
                                                                 value = 12))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              # text area for histogram of total scores
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_totalscores_histogram",
                                                    textAreaInput(inputId = "report_totalscores_histogram_text",
                                                                  label = "Text area",
                                                                  value = "For selected cut-score, blue part of histogram shows students with total score above the cut-score, grey column shows students with total score equal to the cut-score and red part of histogram shows students below the cut-score.",
                                                                  width = "700px", height = "75px"))))),
    #------------------------------------------------------------------------------------
    h4("Scoring"),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # summary table of standard scores
                  checkboxInput(inputId = "report_standardscores_table",
                                label = "Summary table of standard scores",
                                value = T)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for summary table of standard scores
                  conditionalPanel(condition = "input.report_standardscores_table",
                                   conditionalPanel(condition = "input.report_customize",
                                                    textAreaInput(inputId = "report_standardscores_table_text",
                                                                  label = "Text area",
                                                                  value = "Total score also known as raw score is a total number of correct answers. It can be used to compare individual score to a norm group, e.g. if the mean is 12, then individual score can be compared to see if it is below or above this average. Percentile indicates the value below which a percentage of observations falls, e.g. a individual score at the 80th percentile means that the individual score is the same or higher than the scores of 80% of all respondents. Success rate is the percentage of success, e.g. if the maximum points of test is equal to 20 and individual score is 12 then success rate is 12/20 = 0.6, i.e. 60%. Z-score or also standardized score is a linear transformation of total score with a mean of 0 and with variance of 1. If X is total score, M its mean and SD its standard deviation then Z-score = (X - M) / SD. T-score is transformed Z-score with a mean of 50 and standard deviation of 10. If Z is Z-score then T-score = (Z * 10) + 50.",
                                                                  width = "700px", height = "195px"))))),
    #------------------------------------------------------------------------------------
    h4("Validity"),
    h5("Correlation structure"),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # correlation heatmap
                  checkboxInput(inputId = "report_corrplot",
                                label = "Correlation heatmap",
                                value = F)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  # number of cluster for correlation heatmap
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_corrplot",
                                                    numericInput(inputId = 'report_corrplot_numclust',
                                                                 label = 'Number of clusters',
                                                                 value = 1,
                                                                 min = 1,
                                                                 max = 1)))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  # number of cluster for correlation heatmap
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_corrplot",
                                                    selectInput(inputId = 'report_corrplot_methodclust',
                                                                label = 'Clustering method',
                                                                choices = list("None" = "none",
                                                                               "Ward's"  = "ward.D",
                                                                               "Ward's n. 2" = "ward.D2",
                                                                               "Single" = "single",
                                                                               "Complete" = "complete",
                                                                               "Average" = "average",
                                                                               "McQuitty" = "mcquitty",
                                                                               "Median" = "median",
                                                                               "Centroid" = "centroid"),
                                                                selected = "none"))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for correlation heatmap
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_corrplot",
                                                    textAreaInput(inputId = "report_corrplot_text",
                                                                  label = "Text area",
                                                                  value = "Polychoric correlation heat map is a correlation plot which displays a polychoric correlations of items. The size and shade of circles indicate how much the items are correlated (larger and darker circle means larger correlation). The color of circles indicates in which way the items are correlated - blue color shows possitive correlation and red color shows negative correlation.",
                                                                  width = "700px", height = "95px"))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # scree plot
                  checkboxInput(inputId = "report_screeplot",
                                label = "Scree plot",
                                value = F)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  # text area for scree plot
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_screeplot",
                                                    textAreaInput(inputId = "report_screeplot_text",
                                                                  label = "Text area",
                                                                  value = "Scree plot displays the eigenvalues associated with an component or a factor in descending order versus the number of the component or factor.",
                                                                  width = "700px", height = "55px"))))),

    h5("Predictive validity"),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # predictive validity plot
                  checkboxInput(inputId = "report_predictivevalidity_plot",
                                label = "Predictive validity",
                                value = FALSE)),
                  div(style = "display: inline-block; vertical-align: top; width: 3%; "),
                  div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                      # text area for predictive validity plot
                      conditionalPanel(condition = "input.report_customize",
                                       conditionalPanel(condition = "input.report_predictivevalidity_plot",
                                                        textAreaInput(inputId = "report_predictivevalidity_plot_text",
                                                                      label = "Text area",
                                                                      value = "Test for association between total score and criterion variable is based on Spearman`s rho. The null hypothesis is that correlation is 0. Results: rho = 0.35 (p-value <0.01). Interpretation: The p-value is less than 0.05, thus we reject the null hypothesis; total score and criterion variable are positively correlated.",
                                                                      width = "700px", height = "75px"))))),
    #------------------------------------------------------------------------------------
    h4("Traditional item analysis"),
    h5("Item analysis"),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # DDplot
                  checkboxInput(inputId = "report_DDplot",
                                label = "Difficulty/discrimination plot",
                                value = TRUE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_DDplot",
                                                    sliderInput(inputId = 'report_DDplot_numgroups',
                                                                label = 'Number of groups:',
                                                                min   = 1,
                                                                max   = 5,
                                                                value = 3)))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_DDplot",
                                                    sliderInput(inputId = "report_DDplot_range",
                                                                label = "Which two groups to compare:",
                                                                min = 1,
                                                                max = 3,
                                                                step = 1,
                                                                value = c(1, 3)))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for DDplot
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_DDplot",
                                                    textAreaInput(inputId = "report_DDplot_text",
                                                                  label = "Text area",
                                                                  value = "Difficulty (red) of items is estimated as percent of students who answered correctly to that item. Discrimination (blue) is by default described by difference of percent correct in upper and lower third of students (Upper-Lower Index, ULI). By rule of thumb it should not be lower than 0.2 (borderline in the plot), except for very easy or very difficult items.",
                                                                  width = "700px", height = "95px"))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # traditional item analysis table
                  checkboxInput(inputId = "report_DDtable",
                                label = "Traditional item analysis table",
                                value = TRUE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for traditional item analysis table
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_DDtable",
                                   textAreaInput(inputId = "report_DDtable_text",
                                                 label = "Text area",
                                                 value = "Traditional item analysis table: Diff. - Difficulty of item is estimated as percent of students who answered correctly to that item. SD - standard deviation, ULI - Upper-Lower Index, RIT - Pearson correlation between item and total score, RIR - Pearson correlation between item and rest of items, Alpha Drop - Cronbach’s alpha of test without given item, Cust. D.- difference between the difficulty recorded in the groups selected by user.",
                                                 width = "700px", height = "115px"))))),
    h5("Distractor analysis"),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # distractor plots
                  checkboxInput(inputId = "report_distractor_plots",
                                label = "Distractors plots",
                                value = TRUE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  # type of distractor plots
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_distractor_plots",
                                                    radioButtons(inputId = 'report_distractor_plots_type',
                                                                 label = 'Type',
                                                                 choices = list("Combinations", "Distractors"))))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # type of distractor plots
                  fluidRow(conditionalPanel(condition = "input.report_customize",
                                            conditionalPanel(condition = "input.report_distractor_plots",
                                                             sliderInput(inputId = 'report_distractor_plots_numgroups',
                                                                         label = 'Number of groups:',
                                                                         min   = 1,
                                                                         max   = 5,
                                                                         value = 3)))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for distractors plots
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_distractor_plots",
                                                    textAreaInput(inputId = "report_distractor_plots_text",
                                                                  label = "Text area",
                                                                  value = "Respondents are divided into selected number groups by their total score. Subsequently, the percentage of students in each group who selected given answer (correct answer or distractor) is displayed. The correct answer should be more often selected by strong students than by students with lower total score, i.e. solid line should be increasing. The distractor should work in opposite direction, i.e. dotted lines should be decreasing.",
                                                                  width = "700px", height = "115px"))))),
    #------------------------------------------------------------------------------------
    h4("IRT models"),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  # irt
                  checkboxInput(inputId = "report_irt",
                                label = "IRT analysis",
                                value = TRUE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  # irt type model
                  conditionalPanel(condition = "input.report_irt",
                                   radioButtons(inputId = "report_irt_model",
                                                label = "IRT model selection",
                                                choices = c("Rasch" = "rasch",
                                                            "1PL" = "1pl",
                                                            "2PL" = "2pl",
                                                            "3PL" = "3pl"),
                                                selected = "1pl"))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  # irt equation
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_irt",
                                                    checkboxInput(inputId = "report_irt_equation",
                                                                  label = "Equation of model",
                                                                  value = TRUE))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
              # text area for irt models
              conditionalPanel(condition = "input.report_customize",
                               conditionalPanel(condition = "input.report_irt",
                                                textAreaInput(inputId = "report_irt_text",
                                                              label = "Text area",
                                                              value = "Item Response Theory (IRT) models are mixed-effect regression models in which student ability (theta) is assumed to be a random effect and is estimated together with item paramters. Ability (theta) is often assumed to follow normal distibution.",
                                                              width = "700px", height = "75px"))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 20%; ",
                  # wright map
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_irt",
                                                    checkboxInput(inputId = "report_irt_wrightmap",
                                                                  label = "Wright map based on 1PL model",
                                                                  value = TRUE))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
              # text area for wright map
              conditionalPanel(condition = "input.report_customize",
                               conditionalPanel(condition = "input.report_irt",
                                                conditionalPanel(condition = "input.report_irt_wrightmap",
                                                                 textAreaInput(inputId = "report_irt_wrightmap_text",
                                                                               label = "Text area for Wright map",
                                                                               value = "Wright map, also called item-person map, is a graphical tool to display person estimates and item parameters. The person side (left) represents histogram of estimated knowledge of students. The item side (right) displays estimates of difficulty of particular items.",
                                                                               width = "700px", height = "75px")))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
              # text area for table of parameters
              conditionalPanel(condition = "input.report_customize",
                               conditionalPanel(condition = "input.report_irt",
                                                textAreaInput(inputId = "report_irt_table_text",
                                                              label = "Text area for table of parameters",
                                                              value = "Estimates of parameters are completed by SX2 item fit statistics. SX2 is computed only when no missing data are present. In such a case consider using imputed dataset!",
                                                              width = "700px", height = "55px"))))),
    #------------------------------------------------------------------------------------
    h4("DIF/Fairness analysis"),
    # histograms
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  p(strong("DIF method selection")),
                  checkboxInput(inputId = "report_dif_histograms",
                                label = "None - histograms by group only",
                                value = FALSE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_histograms",
                                                    numericInput(inputId = "report_dif_histograms_cutscore",
                                                                 label = "Cut score",
                                                                 value = 12))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for histograms
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_histograms",
                                                    textAreaInput(inputId = "report_dif_histograms_text",
                                                                  label = "Text area",
                                                                  value = "DIF is not about total scores! Two groups may have the same distribution of total scores, yet, some item may function differently for two groups. Also, one of the groups may have signifficantly lower total score, yet, it may happen that there is no DIF item!",
                                                                  width = "700px", height = "75px"))))),
    # delta plot
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  checkboxInput(inputId = "report_dif_deltaplot",
                                label = "Delta plot",
                                value = FALSE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_deltaplot",
                                                    radioButtons(inputId = 'report_dif_deltaplot_threshold',
                                                                 label = 'Threshold',
                                                                 choices = list("Fixed", "Normal"))))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_deltaplot",
                                                    checkboxInput(inputId = 'report_dif_deltaplot_purification',
                                                                  label = 'Item purification',
                                                                  value = FALSE)))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_deltaplot",
                                                    conditionalPanel(condition = "input.report_dif_deltaplot_purification",
                                                                     selectInput(inputId = "report_dif_deltaplot_purification_type",
                                                                                 label = "Purification method",
                                                                                 choices = c("IPP1" = "IPP1",
                                                                                             "IPP2" = "IPP2",
                                                                                             "IPP3" = "IPP3"),
                                                                                 selected = "IPP1")))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for delta plot
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_deltaplot",
                                                    textAreaInput(inputId = "report_dif_deltaplot_text",
                                                                  label = "Text area",
                                                                  value = "Delta plot compares the proportions of correct answers per item in the two groups. It displays non-linear transformation of these proportions using quantiles of standard normal distributions (so called delta scores) for each item for the two groups in a scatterplot called diagonal plot or delta plot . Item is under suspicion of DIF if the delta point considerably departs from the diagonal.",
                                                                  width = "700px", height = "95px"))))),
    # logistic regression
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  checkboxInput(inputId = "report_dif_logistic",
                                label = "Logistic regression",
                                value = FALSE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 18%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_logistic",
                                                    radioButtons(inputId = 'report_dif_logistic_type',
                                                                 label = 'Type',
                                                                 choices = c("H0: Any DIF vs. H1: No DIF" = 'both',
                                                                             "H0: Uniform DIF vs. H1: No DIF" = 'udif',
                                                                             "H0: Non-Uniform DIF vs. H1: Uniform DIF" = 'nudif'),
                                                                 selected = 'both')))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_logistic",
                                                    selectInput(inputId = "report_dif_logistic_correctionmethod",
                                                                label = "Correction method",
                                                                choices = c("BH" = "BH",
                                                                            "Holm" = "holm",
                                                                            "Hochberg" = "hochberg",
                                                                            "Hommel" = "hommel",
                                                                            "BY" = "BY",
                                                                            "FDR" = "fdr",
                                                                            "none" = "none" ),
                                                                selected = "none")))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_logistic",
                                                    checkboxInput(inputId = 'report_dif_logistic_purification',
                                                                  label = 'Item purification',
                                                                  value = FALSE))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for logistic regression
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_logistic",
                                                    textAreaInput(inputId = "report_dif_logistic_text",
                                                                  label = "Text area",
                                                                  value = "Logistic regression allows for detection of uniform and non-uniform DIF by adding a group specific intercept (uniform DIF) and group specific interaction (non-uniform DIF) into model and by testing for their significance.",
                                                                  width = "700px", height = "75px"))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for logistic regression plots
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_logistic",
                                                    textAreaInput(inputId = "report_dif_logistic_plot_text",
                                                                  label = "Text area for plots",
                                                                  value = "Points represent proportion of selected answer with respect to standardized total score. Size of points is determined by count of respondents who chose particular answer. ",
                                                                  width = "700px", height = "55px"))))),
    # multinomial regression
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 15%; ",
                  checkboxInput(inputId = "report_dif_multinomial",
                                label = "Multinomial regression",
                                value = FALSE)),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 18%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_multinomial",
                                                    radioButtons(inputId = 'report_dif_multinomial_type',
                                                                 label = 'Type',
                                                                 choices = c("H0: Any DIF vs. H1: No DIF" = 'both',
                                                                             "H0: Uniform DIF vs. H1: No DIF" = 'udif',
                                                                             "H0: Non-Uniform DIF vs. H1: Uniform DIF" = 'nudif'),
                                                                 selected = 'both')))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_multinomial",
                                                    selectInput(inputId = "report_dif_multinomial_correctionmethod",
                                                                label = "Correction method",
                                                                choices = c("BH" = "BH",
                                                                            "Holm" = "holm",
                                                                            "Hochberg" = "hochberg",
                                                                            "Hommel" = "hommel",
                                                                            "BY" = "BY",
                                                                            "FDR" = "fdr",
                                                                            "none" = "none" ),
                                                                selected = "none")))),
              div(style = "display: inline-block; vertical-align: top; width: 3%; "),
              div(style = "display: inline-block; vertical-align: top; width: 10%; ",
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_multinomial",
                                                    checkboxInput(inputId = 'report_dif_multinomial_purification',
                                                                  label = 'Item purification',
                                                                  value = FALSE))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for multinomial regression
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_multinomial",
                                                    textAreaInput(inputId = "report_dif_multinomial_text",
                                                                  label = "Text area",
                                                                  value = "Differential Distractor Functioning (DDF) occurs when people from different groups but with the same knowledge have different probability of selecting at least one distractor choice. DDF is here examined by multinomial log-linear regression model with Z-score and group membership as covariates. ",
                                                                  width = "700px", height = "75px"))))),
    fluidPage(div(style = "display: inline-block; vertical-align: top; width: 18%; "),
              div(style = "display: inline-block; vertical-align: top; width: 80%; ",
                  # text area for multinomial regression plots
                  conditionalPanel(condition = "input.report_customize",
                                   conditionalPanel(condition = "input.report_dif_multinomial",
                                                    textAreaInput(inputId = "report_dif_multinomial_plot_text",
                                                                  label = "Text area for plots",
                                                                  value = "Points represent proportion of selected answer with respect to standardized total score. Size of points is determined by count of respondents who chose particular answer. ",
                                                                  width = "700px", height = "55px")))))
    )


  server <- function(input, output) {
  }

  shinyApp(ui, server)
}
