% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICCrestricted.R
\name{ICCrestricted}
\alias{ICCrestricted}
\title{Range-restricted reliability with intra-class correlation}
\usage{
ICCrestricted(
  Data,
  case,
  var,
  rank = NULL,
  dir = "top",
  sel = 1,
  nsim = 100,
  ci = 0.95,
  seed = NULL
)
}
\arguments{
\item{Data}{\code{matrix} or \code{data.frame} which includes variables
describing ID of ratees (specified in \code{case}), ratings (specified in
\code{var}), and (optionally) rank of ratees (specified in \code{rank}).}

\item{case}{character: name of the variable in \code{Data} with ID of the
ratee (subject or object being evaluated, such as a respondent, proposal,
patient, applicant etc.)}

\item{var}{character: name of the variable in \code{Data} with the
ratings/scores.}

\item{rank}{numeric: vector of ranks of ratees. If not provided, rank of
ratee is calculated based on average rating based on \code{var} variable.}

\item{dir}{character: direction of range-restriction, available options are
\code{"top"} (default) or \code{"bottom"}. Can be an unambiguous
abbreviation (i.e., \code{"t"} or \code{"b"}).}

\item{sel}{numeric: selected number (given > 1) or percentage (given <= 1) of
ratees. Default value is 1 (complete dataset).}

\item{nsim}{numeric: number of simulations for bootstrap confidence interval.
Default value is 100.}

\item{ci}{numeric: confidence interval. Default value is 0.95.}

\item{seed}{seed for simulations. Default value is \code{NULL}, random seed.
See \code{\link[lme4:bootMer]{lme4::bootMer}} for more detail.}
}
\value{
A \code{data.frame} with the following columns: \item{n_sel}{number
  of ratees selected/subsetted.} \item{prop_sel}{proportion of ratees
  selected.} \item{dir}{direction of range-restriction. \code{NA} if range is
  effectively not restricted (100% used).} \item{VarID}{variance due to
  ratee, "true variance", between-group variance.} \item{VarResid}{residual
  variance.} \item{VarTotal}{total variance.} \item{ICC1}{single-rater
  inter-rater reliability.} \item{ICC1_LCI}{lower bound of the confidence
  interval for \code{ICC1}.} \item{ICC1_UCI}{upper bound of the confidence
  interval for \code{ICC1}.} \item{ICC3}{multiple-rater inter-rater
  reliability.} \item{ICC3_LCI}{lower bound of the confidence interval for
  \code{ICC3}.} \item{ICC3_UCI}{upper bound of the confidence interval for
  \code{ICC3}.}
}
\description{
Function estimating reliability with intra-class correlation for the complete
or for the range-restricted sample.
}
\examples{
# loading AIBS dataset
data(AIBS, package = "ShinyItemAnalysis")

# ICC for the whole sample
ICCrestricted(Data = AIBS, case = "ID", var = "Score", rank = "ScoreRankAdj")

# ICC for the range-restricted sample considering 80\% of top ratees
ICCrestricted(Data = AIBS, case = "ID", var = "Score", rank = "ScoreRankAdj",
              sel = 0.8)

}
\references{
Erosheva, E., Martinkova, P., & Lee, C. (2021a). When zero may not be zero: A
cautionary note on the use of inter-rater reliability in evaluating grant
peer review. Journal of the Royal Statistical Society - Series A. Accepted.

Erosheva, E., Martinkova, P., & Lee, C. (2021b). Supplementary material for
When zero may not be zero: A cautionary note on the use of inter-rater
reliability in evaluating grant peer review.
}
\author{
Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr

Jan Netik \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
}
