% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{FRiP}
\alias{FRiP}
\title{Calculate fraction of reads in peaks per cell}
\usage{
FRiP(object, peak.assay, bin.assay, chromosome = "chr1", verbose = TRUE)
}
\arguments{
\item{object}{A Seurat object}

\item{peak.assay}{Name of the assay containing a peak x cell matrix}

\item{bin.assay}{Name of the assay containing a bin x cell matrix}

\item{chromosome}{Which chromosome to use. Default is chromosome 1 ('chr1').
If NULL, use the whole genome.}

\item{verbose}{Display messages}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
Calculate fraction of reads in peaks per cell
}
\examples{
FRiP(object = atac_small, peak.assay = 'peaks', bin.assay = 'bins')
}
