% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GetReadsInRegion}
\alias{GetReadsInRegion}
\title{GetReadsInRegion}
\usage{
GetReadsInRegion(
  object,
  region,
  assay = NULL,
  tabix.file = NULL,
  group.by = NULL,
  cells = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{region}{A genomic region, specified as a string in the format
'chr:start-end'. Can be a vector of regions.}

\item{assay}{Name of assay to use}

\item{tabix.file}{A TabixFile object. If NULL, the file specified in
\code{fragment.path} will be opened and closed after the function completes.
If iterating over many regions, providing an open TabixFile is much faster
as it avoids opening and closing the connection each time.}

\item{group.by}{Cell grouping information to add}

\item{cells}{Cells to include. Default is all cells present in the object.}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{\link{StringToGRanges}}}
}
\value{
Returns a data frame
}
\description{
Extract reads for each cell within a given genomic region or set of regions
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
atac_small <- SetFragments(object = atac_small, file = fpath)
region <- StringToGRanges(regions = "chr1-10245-762629")
GetReadsInRegion(object = atac_small, region = region)
}
