% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{RegionPlot}
\alias{RegionPlot}
\title{Region plot}
\usage{
RegionPlot(
  object,
  key,
  assay = NULL,
  idents = NULL,
  normalize = TRUE,
  upstream = NULL,
  downstream = NULL,
  window = (upstream + downstream)/500,
  nrow = NULL
)
}
\arguments{
\item{object}{A Seurat object}

\item{key}{Name of key to pull data from. Stores the results from
\code{\link{RegionMatrix}}}

\item{assay}{Name of assay to use. If a list or vector of assay names is
given, data will be plotted from each assay. Note that all assays must
contain \code{RegionMatrix} results with the same key. Sorting will be 
defined by the first assay in the list}

\item{idents}{Cell identities to include. Note that cells cannot be
regrouped, this will require re-running \code{RegionMatrix} to generate a 
new set of matrices}

\item{normalize}{Normalize by number of cells in each group}

\item{upstream}{Number of bases to include upstream of region. If NULL, use
all bases that were included in the \code{RegionMatrix} function call. Note
that this value cannot be larger than the value for \code{upstream} given in
the original \code{RegionMatrix} function call. If NULL, use parameters that
were given in the \code{RegionMatrix} function call}

\item{downstream}{Number of bases to include downstream of region. See
documentation for \code{upstream}}

\item{window}{Smoothing window to apply}

\item{nrow}{Number of rows to use when creating plot. If NULL, chosen
automatically by ggplot2}
}
\value{
Returns a ggplot2 object
}
\description{
Plot fragment counts within a set of regions.
}
\seealso{
RegionMatrix
}
\concept{heatmap}
\concept{visualization}
