% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{bias}
\alias{bias}
\title{Compute (relative) bias summary statistic}
\usage{
bias(estimate, parameter = NULL, relative = FALSE)
}
\arguments{
\item{estimate}{a \code{numeric} vector or \code{matrix}/\code{data.frame}
of parameter estimates. If a vector,
the length is equal to the number of replications. If a \code{matrix}/\code{data.frame},
the number of rows must equal the number of replications}

\item{parameter}{a \code{numeric} scalar/vector indicating the fixed parameters.
If a single value is supplied and \code{estimate} is a \code{matrix}/\code{data.frame}
then the value will be recycled for each column.
If \code{NULL} then it will be assumed that the \code{estimate} input is in a deviation
form (therefore \code{mean(estimate))} will be returned)}

\item{relative}{logical; compute the relative bias statistic (i.e., divide the bias by the value
in \code{parameter})? Default is \code{FALSE}}
}
\value{
returns a \code{numeric} vector indicating the overall (relative) bias in the estimates
}
\description{
Computes the (relative) bias of a sample estimate from the parameter value.
Accepts estimate and parameter values, as well as estimate values which are in deviation form.
If relative bias is requested the \code{estimate} and \code{parameter} inputs are both required.
}
\examples{

pop <- 2
samp <- rnorm(100, 2, sd = 0.5)
bias(samp, pop)
bias(samp, pop, relative = TRUE)

dev <- samp - pop
bias(dev)

# equivalent here
bias(mean(samp), pop)

# matrix input
mat <- cbind(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
bias(mat, parameter = 2)

# same, but with data.frame
df <- data.frame(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
bias(df, parameter = c(2,2))

# parameters of the same size
parameters <- 1:10
estimates <- parameters + rnorm(10)
bias(estimates, parameters)


}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\url{http://www.tandfonline.com/doi/full/10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{RMSE}}
}
