% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SimInf_model.R
\docType{methods}
\name{events}
\alias{events}
\alias{events,SimInf_model-method}
\title{Extract the events from a \code{SimInf_model} object}
\usage{
events(model)

\S4method{events}{SimInf_model}(model)
}
\arguments{
\item{model}{The \code{model} to extract the events from.}
}
\value{
\code{SimInf_events} object.
}
\description{
Extract the events from a \code{SimInf_model} object
}
\examples{
## Create an SIR model that includes scheduled events.
model <- SIR(u0     = u0_SIR(),
             tspan  = 1:(4 * 365),
             events = events_SIR(),
             beta   = 0.16,
             gamma  = 0.077)

## Extract the scheduled events from the model and
## display summary
summary(events(model))

## Extract the scheduled events from the model and
## plot summary
plot(events(model))
}
\keyword{methods}
