% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_moments.R
\name{calc_moments}
\alias{calc_moments}
\title{Find Standardized Cumulants of Data by Method of Moments}
\usage{
calc_moments(x)
}
\arguments{
\item{x}{a vector of data}
}
\value{
A vector of the mean, standard deviation, skewness, standardized kurtosis, and standardized fifth and sixth cumulants
}
\description{
This function uses the method of moments to calculate the mean, standard deviation, skewness,
    standardized kurtosis, and standardized fifth and sixth cumulants given a vector of data.  The result can be used
    as input to \code{\link[SimMultiCorrData]{find_constants}} or for data simulation.
}
\examples{
x <- rgamma(n = 10000, 10, 10)
calc_moments(x)
}
\references{
Headrick TC (2002). Fast Fifth-order Polynomial Transforms for Generating Univariate and Multivariate
    Non-normal Distributions. Computational Statistics & Data Analysis, 40(4):685-711. \doi{10.1016/S0167-9473(02)00072-5}.
    (\href{http://www.sciencedirect.com/science/article/pii/S0167947302000725}{ScienceDirect})

Headrick TC, Kowalchuk RK (2007). The Power Method Transformation: Its Probability Density Function, Distribution
    Function, and Its Further Use for Fitting Data. Journal of Statistical Computation and Simulation, 77, 229-249. \doi{10.1080/10629360600605065}.

Headrick TC, Sheng Y, & Hodis FA (2007). Numerical Computing and Graphics for the Power Method Transformation Using
    Mathematica. Journal of Statistical Software, 19(3), 1 - 17. \doi{10.18637/jss.v019.i03}.

Kendall M & Stuart A (1977). The Advanced Theory of Statistics, 4th Edition. Macmillan, New York.
}
\seealso{
\code{\link[SimMultiCorrData]{calc_fisherk}}, \code{\link[SimMultiCorrData]{calc_theory}},
         \code{\link[SimMultiCorrData]{find_constants}}
}
\keyword{cumulants,}
\keyword{method}
\keyword{moments}
\keyword{of}
