% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_pop.R
\name{sim_vonB}
\alias{sim_vonB}
\title{Closure for simulating length given age using von Bertalanffy notation}
\usage{
sim_vonB(
  Linf = 120,
  L0 = 5,
  K = 0.1,
  log_sd = 0.1,
  length_group = 3,
  digits = 0,
  plot = FALSE
)
}
\arguments{
\item{Linf}{Mean asymptotic length.}

\item{L0}{Length at birth.}

\item{K}{Growth rate parameter.}

\item{log_sd}{Standard deviation of the length-at-age relationship on the log scale.}

\item{length_group}{Length group width for constructing the length-at-age key.
Labels on the resulting matrix use midpoints according to DFO conventions; see \code{\link[=group_lengths]{group_lengths()}}.
This value will also determine the length groupings used in the stratified analysis via \code{\link[=run_strat]{run_strat()}}.}

\item{digits}{Number of decimal places to round simulated lengths to.}

\item{plot}{Logical. Should a simple plot of the simulated values be produced?}
}
\value{
A function that can be passed to \code{\link[=sim_abundance]{sim_abundance()}}.
}
\description{
This function returns a closure that holds the supplied parameter values and can be used to
either simulate lengths given ages or generate a length-at-age key from a sequence of ages.
}
\examples{
growth_fun <- sim_vonB(Linf = 100, L0 = 5, K = 0.2, log_sd = 0.05, length_group = 1, plot = TRUE)
growth_fun(age = rep(1:15, each = 100))
growth_fun(age = 1:15, length_age_key = TRUE)

sim_abundance(growth = sim_vonB(plot = TRUE))

}
