% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkeweDF_functions.R
\name{psi_criterion}
\alias{psi_criterion}
\title{Psi Criterion}
\usage{
psi_criterion(data, model, n_parameters)
}
\arguments{
\item{data}{Vector of observed values}

\item{model}{Vector of theoretical values to be compared}

\item{n_parameters}{Number of parameters of function used to generate model}
}
\description{
This function generates the Psi Criterion goodness of fit value given an empirical distribution, theoretical modeled distribution, and number of parameters in the theoretical distribution.
}
\examples{
obs_data <- c(100,75,20,1)
model_data <- Kolmogorov_Waring(length(obs_data), 2, 3, 0.9)
psi <- psi_criterion(obs_data, model_data, 3)
}
