% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLS2way.R
\name{PLS2way}
\alias{PLS2way}
\title{Two-way table from PLSrounding output}
\usage{
PLS2way(obj, variable = c("rounded", "original", "difference", "code"))
}
\arguments{
\item{obj}{Output object from \code{\link{PLSrounding}}}

\item{variable}{One of \code{"rounded"} (default), \code{"original"}, \code{"difference"} or \code{"code"}.}
}
\value{
A data frame
}
\description{
Two-way table from PLSrounding output
}
\details{
When parameter \code{"variable"} is \code{"code"}, output is coded as  \code{"#"} (publish), \code{"."} (inner) and \code{"&"} (both).
}
\examples{
# Making tables from PLSrounding examples 
z <- SmallCountData("e6")
a <- PLSrounding(z, "freq", formula = ~eu * year + geo)
PLS2way(a, "original")
PLS2way(a, "difference")
PLS2way(a, "code")
PLS2way(PLSrounding(z, "freq", formula = ~eu * year + geo * year), "code")
eHrc2 <- list(geo = c("EU", "@Portugal", "@Spain", "Iceland"), year = c("2018", "2019"))
PLS2way(PLSrounding(z, "freq", hierarchies = eHrc2))
}
