% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoftClassMatrix.R
\name{SoftClassMatrix}
\alias{SoftClassMatrix}
\title{Converting response vector to sparse matrix.}
\usage{
SoftClassMatrix(responses, classes = NA)
}
\arguments{
\item{responses}{A vector of classification responses.}

\item{classes}{A vector of possible classifications with a manually specified order.  Must contain all elements in the responses vector.}
}
\value{
A matrix where \code{1} indicates that observation was classified as that column's response and \code{0} if not.
}
\description{
\code{SoftClassMatrix} converts a classification response matrix into a sparse matrix that can be used for inputs
into the \code{SoftRandomForest} function.
}
\details{
\code{SoftClassMatrix} runs through each line of a classification vector and creates a sparse matrix where each column represents
an individual classification.  The output matrix has number of rows equal to the number of rows of the input vector and number of columns
equal to the number of unique entries in the input vector.  The order is determined by the order they appear in the vector.
Adjust this afterwards if another order is desired.
}
\examples{
Input = c("A", "C", "B", "B", "A", "B")
SoftClassMatrix(Input, classes = c("A", "B", "C", "D"))
}
