% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sad.R
\name{Sad}
\alias{Sad}
\title{Relative saturation function}
\usage{
Sad(suc, par.shp, modality = c("uni"), suc.negativ = TRUE)
}
\arguments{
\item{suc}{Suction/pressure heads. Negative if suc.negativ = TRUE}

\item{par.shp}{named parameter of soil hydraulic properties in list or vector (see details)}

\item{modality}{pore size distribution ('uni' or 'bi')}

\item{suc.negativ}{set TRUE if suction/pressure heads are negative and FALSE if positive}
}
\description{
Relative saturation function for adsorptive water storage described by a piecwise linear function (Iden and Durner, 2014).
}
\details{
\describe{\item{par.shp:}{
ths [-]: saturated water content \cr
thr [-]: residual water content \cr
alfa [1/L]: van Genuchten shape parameter \cr
n [-]: van Genuchten shape parameter \cr
h0 [L]: suction at water content of 0 (i.e. oven dryness) (h0 = 10^6.8 if missing, corresponding to oven dryness at 105°C (Schneider and Goss, 2012))}
\item{}{additional for bimodal (modality == 'bi'): \cr
alfa2 [1/L]: van Genuchten parameter alfa for second pore space distribution \cr
n2 [-]: van Genuchten parameter n for second pore space distribution}}
}
\references{
Iden, S., Durner, W. (2014). Comment to Simple consistent models for water retention and hydraulic conductivity in the complete moisture range by A. Peters. Water Resour. Res. 50, 7530–7534.

Schneider, M., & Goss, K. U. (2012). Prediction of the water sorption isotherm in air dry soils. Geoderma, 170, 64-69.
}
\author{
Ullrich Dettmann
}
