% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higherTaxaLevels.R
\name{taxon_to_level}
\alias{taxon_to_level}
\title{Determine taxonomic level of specified taxa}
\usage{
taxon_to_level(taxon)
}
\arguments{
\item{taxon}{character vector of taxon names at Order, Suborder, Great Group or Subgroup level.}
}
\value{
character of taxonomic hierarchy levels (such as "order", "suborder", "greatgroup", "subgroup", "family") for each element of input vector.
}
\description{
Taxa that resolve to a subgroup level taxon and contain a comma \code{","} are assumed to be \code{"family"}-level.
}
\examples{

# get the taxonomic levels for various taxa

taxon_to_level(c("gelisols", NA, "foo", "typic folistels", "folistels"))

}
