% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnalytes.R, R/getMeta.R, R/z-deprecated.R
\name{getAnalytes}
\alias{getAnalytes}
\alias{getMeta}
\alias{getFeatures}
\title{Get Analytes}
\usage{
getAnalytes(x, n = FALSE, rm.controls = FALSE)

getMeta(x, n = FALSE)

getFeatures(x, n = FALSE, rm.controls = FALSE)
}
\arguments{
\item{x}{Typically a \code{soma_adat} class object created using \code{\link[=read_adat]{read_adat()}}.}

\item{n}{Logical. Return an integer corresponding to the \emph{length}
of the features?}

\item{rm.controls}{Logical. Should all control and non-human analytes
(e.g. \code{HybControls}, \code{Non-Human}, \code{Non-Biotin}, \code{Spuriomer}) be removed
from the returned value?}
}
\value{
\code{\link[=getAnalytes]{getAnalytes()}}: a character vector of ADAT feature ("analyte") names.

\code{\link[=getMeta]{getMeta()}}: a character vector of ADAT clinical ("meta") data names.

For both, if \code{n = TRUE}, an integer corresponding to the
\strong{length} of the character vector.
}
\description{
Return the feature names (i.e. the column names for
SOMAmer reagent analytes) from a \code{soma_adat}.
S3 methods also exist for these classes:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] getAnalytes.character  getAnalytes.data.frame getAnalytes.default   
#> [4] getAnalytes.list       getAnalytes.matrix     getAnalytes.recipe    
#> [7] getAnalytes.soma_adat 
#> see '?methods' for accessing help and source code
}\if{html}{\out{</div>}}

\code{\link[=getMeta]{getMeta()}} returns the inverse, a character vector of string
names of \emph{non}-analyte feature columns/variables, which typically
correspond to the clinical ("meta") data variables.
S3 methods exist for these classes:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] getMeta.character  getMeta.data.frame getMeta.default    getMeta.list      
#> [5] getMeta.matrix     getMeta.soma_adat 
#> see '?methods' for accessing help and source code
}\if{html}{\out{</div>}}
}
\section{Functions}{
\itemize{
\item \code{getFeatures()}: renamed in \pkg{SomaDataIO v5.1.0}. Exported
(with life-cycle warning) to maintain backward compatibility.
Please adjust your code accordingly.

}}
\examples{
# RFU feature variables
apts <- getAnalytes(example_data)
head(apts)
getAnalytes(example_data, n = TRUE)

# vector string
bb <- getAnalytes(names(example_data))
all.equal(apts, bb)

# create some control sequences
# ~~~~~~~~~ Spuriomer ~~~ HybControl ~~~
apts2 <- c("seq.2053.2", "seq.2171.12", head(apts))
apts2
no_crtl <- getAnalytes(apts2, rm.controls = TRUE)
no_crtl
setdiff(apts2, no_crtl)

# clinical variables
mvec <- getMeta(example_data)
head(mvec, 10)
getMeta(example_data, n = TRUE)

# test 'data.frame' and 'character' S3 methods are identical
identical(getMeta(example_data), getMeta(names(example_data))) # TRUE
}
\seealso{
\code{\link[=is.apt]{is.apt()}}
}
\author{
Stu Field
}
