% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{parameters}
\alias{parameters}
\title{Estimation of parameters for test equality of two normal distributions}
\usage{
parameters(
  data,
  classes,
  shrink = TRUE,
  shrink.function = shrinkTEGS,
  shrink.param = list(probs = 0.05, type = "min")
)
}
\arguments{
\item{data}{an expression matrix with colnames for variables and row names for samples}

\item{classes}{a vector of length equal to the number of rows of data. It indicates the class (condition) of each statistical unit. Only two classes, labeled as 1 and 2, are allowed}

\item{shrink}{boolean. if \code{FALSE} the maximum likelihood estimates are returned; if \code{TRUE} the shrinkage estimates are returned instead}

\item{shrink.function}{function that implements the shrinkage method. It must return a list object with all the elements required as input arguments in \code{\link[SourceSet]{testMeanVariance}}. Default is \code{\link[SourceSet]{shrinkTEGS}} function.}

\item{shrink.param}{additional parameters to pass as input arguments of the shrink function specified in the \code{shrink.function}.}
}
\value{
The function returns a list containing: three matrices with maximum likelihood or the shrinkage estimates (pooled, condition1 and condition2), and a list with the used parameters.
}
\description{
The function estimates the parameters of two normal distributions. Both maximum likelihood estimates and shrinkage estimate of covariance matrices are supplied.
}
\examples{
if(require(mvtnorm)){
  ## Generate two random samples of size 50 from two multivariate normal distributions
  # sample size
  n<-50
  # true parameters of class 1 and class 2
  param.class1<-simulation$condition1
  param.class2<-simulation$condition2$`5`$`2`
  # simulated dataset
  data.class1<-rmvnorm(n = n,mean =param.class1$mu ,sigma =param.class1$S)
  data.class2<-rmvnorm(n = n,mean =param.class2$mu ,sigma=param.class2$S)
  data<-rbind(data.class1,data.class2)
  classes<-c(rep(1,nrow(data.class1)),rep(2,nrow(data.class2)))

  ## estimated parameters: maximum likelihood estimate
  est.param<-parameters(data = data,classes =classes ,shrink = FALSE)

  ## estimated parameters: regularized estimate
  est.param.shrink<-parameters(data = data,classes =classes ,shrink = TRUE)
  # tuning values and other info on shrinkage estimate
  str(est.param.shrink$shrink.info)
}
}
\seealso{
\code{\link[SourceSet]{shrinkTEGS}}, \code{\link[SourceSet]{testMeanVariance}}
}
