% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-repository.R
\docType{methods}
\name{checksums}
\alias{checksums}
\alias{checksums,character,character,logical-method}
\alias{checksums,character,character,missing-method}
\title{Calculate checksums for a module's data files}
\usage{
checksums(module, path, write)

\S4method{checksums}{character,character,logical}(module, path, write)

\S4method{checksums}{character,character,missing}(module, path)
}
\arguments{
\item{module}{Character string giving the name of the module.}

\item{path}{Character string giving the path to the module directory.}

\item{write}{Logical indicating whether to overwrite \code{CHECKSUMS.txt}.
Default is \code{FALSE}, as users should not change this file.
Module developers should write this file prior to distributing
their module code, and update accordingly when the data change.}
}
\value{
A data.frame with columns: result, expectedFile, actualFile, and checksum.
}
\description{
Verify (and optionally write) checksums for data files in a module's
\code{data/} subdirectory. The file \code{data/CHECKSUMS.txt} contains the
expected checksums for each data file.
Checksums are computed using \code{SpaDES:::digest}, which is simply a
wrapper around \code{digest::digest}.
}
\details{
Modules may require data that for various reasons cannot be distributed with
the module source code. In these cases, the module developer should ensure
that the module downloads and extracts the data required. It is useful to not
only check that the data files exist locally but that their checksums match
those expected. See also \code{\link{downloadData}}.
}
\note{
In version 1.2.0 and earlier, two checksums per file were required
because of differences in the checksum hash values on Windows and Unix-like
platforms. Recent versions use a different (faster) algorithm and only require
one checksum value per file.
To update your \file{CHECKSUMS.txt} files using the new algorithm, see
\url{https://github.com/PredictiveEcology/SpaDES/issues/295#issuecomment-246513405}.
}
\examples{
\dontrun{
moduleName <- "my_module"
modulePath <- file.path("path", "to", "modules")

## verify checksums of all data files
checksums(monudleName, modulePath)

## write new CHECKSUMS.txt file

# 1. verify that all data files are present (and no extra files are present)
list.files(file.path(modulePath, moduleName, "data")

# 2. calculate file checksums and write to file (this will overwrite CHECKSUMS.txt)
checksums(monudleName, modulePath, write = TRUE)
}

}
\author{
Alex Chubaty
}

