% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R, R/functions.R
\docType{methods}
\name{first}
\alias{first}
\alias{first}
\alias{first,SparkDataFrame-method}
\alias{first}
\alias{first,characterOrColumn-method}
\title{Return the first row of a SparkDataFrame}
\usage{
first(x, ...)

\S4method{first}{SparkDataFrame}(x)

\S4method{first}{characterOrColumn}(x, na.rm = FALSE)
}
\arguments{
\item{x}{a SparkDataFrame or a column used in aggregation function.}

\item{...}{further arguments to be passed to or from other methods.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}
}
\description{
Return the first row of a SparkDataFrame

Aggregate function: returns the first value in a group.
}
\details{
The function by default returns the first values it sees. It will return the first non-missing
value it sees when na.rm is set to true. If all values are missing, then NA is returned.
}
\note{
first(SparkDataFrame) since 1.4.0

first(characterOrColumn) since 1.4.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
first(df)
}
\dontrun{
first(df$c)
first(df$c, TRUE)
}
}
\seealso{
Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{gapplyCollect}},
  \code{\link{gapply}}, \code{\link{getNumPartitions}},
  \code{\link{group_by}}, \code{\link{head}},
  \code{\link{histogram}}, \code{\link{insertInto}},
  \code{\link{intersect}}, \code{\link{isLocal}},
  \code{\link{join}}, \code{\link{limit}},
  \code{\link{merge}}, \code{\link{mutate}},
  \code{\link{ncol}}, \code{\link{nrow}},
  \code{\link{persist}}, \code{\link{printSchema}},
  \code{\link{randomSplit}}, \code{\link{rbind}},
  \code{\link{registerTempTable}}, \code{\link{rename}},
  \code{\link{repartition}}, \code{\link{sample}},
  \code{\link{saveAsTable}}, \code{\link{schema}},
  \code{\link{selectExpr}}, \code{\link{select}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{take}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{with}},
  \code{\link{write.df}}, \code{\link{write.jdbc}},
  \code{\link{write.json}}, \code{\link{write.orc}},
  \code{\link{write.parquet}}, \code{\link{write.text}}

Other agg_funcs: \code{\link{agg}}, \code{\link{avg}},
  \code{\link{countDistinct}}, \code{\link{count}},
  \code{\link{kurtosis}}, \code{\link{last}},
  \code{\link{max}}, \code{\link{mean}}, \code{\link{min}},
  \code{\link{sd}}, \code{\link{skewness}},
  \code{\link{stddev_pop}}, \code{\link{stddev_samp}},
  \code{\link{sumDistinct}}, \code{\link{sum}},
  \code{\link{var_pop}}, \code{\link{var_samp}},
  \code{\link{var}}
}
