% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{lag}
\alias{lag}
\alias{lag}
\alias{lag,characterOrColumn-method}
\title{lag}
\usage{
lag(x, ...)

\S4method{lag}{characterOrColumn}(x, offset = 1, defaultValue = NULL)
}
\arguments{
\item{x}{the column as a character string or a Column to compute on.}

\item{...}{further arguments to be passed to or from other methods.}

\item{offset}{the number of rows back from the current row from which to obtain a value.
If not specified, the default is 1.}

\item{defaultValue}{(optional) default to use when the offset row does not exist.}
}
\description{
Window function: returns the value that is \code{offset} rows before the current row, and
\code{defaultValue} if there is less than \code{offset} rows before the current row. For example,
an \code{offset} of one will return the previous row at any given point in the window partition.
}
\details{
This is equivalent to the \code{LAG} function in SQL.
}
\note{
lag since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)

  # Partition by am (transmission) and order by hp (horsepower)
  ws <- orderBy(windowPartitionBy("am"), "hp")

  # Lag mpg values by 1 row on the partition-and-ordered table
  out <- select(df, over(lag(df$mpg), ws), df$mpg, df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{cume_dist}},
  \code{\link{dense_rank}}, \code{\link{lead}},
  \code{\link{ntile}}, \code{\link{percent_rank}},
  \code{\link{rank}}, \code{\link{row_number}}
}
