% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{ntile}
\alias{ntile}
\alias{ntile}
\alias{ntile,numeric-method}
\title{ntile}
\usage{
ntile(x)

\S4method{ntile}{numeric}(x)
}
\arguments{
\item{x}{Number of ntile groups}
}
\description{
Window function: returns the ntile group id (from 1 to n inclusive) in an ordered window
partition. For example, if n is 4, the first quarter of the rows will get value 1, the second
quarter will get 2, the third quarter will get 3, and the last quarter will get 4.
}
\details{
This is equivalent to the \code{NTILE} function in SQL.
}
\note{
ntile since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)

  # Partition by am (transmission) and order by hp (horsepower)
  ws <- orderBy(windowPartitionBy("am"), "hp")

  # Get ntile group id (1-4) for hp
  out <- select(df, over(ntile(4), ws), df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{cume_dist}},
  \code{\link{dense_rank}}, \code{\link{lag}},
  \code{\link{lead}}, \code{\link{percent_rank}},
  \code{\link{rank}}, \code{\link{row_number}}
}
