% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/group.R, R/DataFrame.R
\docType{methods}
\name{agg}
\alias{agg}
\alias{summarize}
\alias{agg}
\alias{agg,GroupedData-method}
\alias{summarize}
\alias{summarize,GroupedData-method}
\alias{agg}
\alias{agg,SparkDataFrame-method}
\alias{summarize}
\alias{summarize,SparkDataFrame-method}
\title{summarize}
\usage{
agg(x, ...)

summarize(x, ...)

\S4method{agg}{GroupedData}(x, ...)

\S4method{summarize}{GroupedData}(x, ...)

\S4method{agg}{SparkDataFrame}(x, ...)

\S4method{summarize}{SparkDataFrame}(x, ...)
}
\arguments{
\item{x}{a SparkDataFrame or GroupedData.}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
A SparkDataFrame.
}
\description{
Aggregates on the entire SparkDataFrame without groups.
The resulting SparkDataFrame will also contain the grouping columns.

Compute aggregates by specifying a list of columns
}
\details{
df2 <- agg(df, <column> = <aggFunction>)
df2 <- agg(df, newColName = aggFunction(column))
}
\note{
agg since 1.4.0

summarize since 1.4.0

agg since 1.4.0

summarize since 1.4.0
}
\examples{
\dontrun{
 df2 <- agg(df, age = "sum")  # new column name will be created as 'SUM(age#0)'
 df3 <- agg(df, ageSum = sum(df$age)) # Creates a new column named ageSum
 df4 <- summarize(df, ageSum = max(df$age))
}
}
\seealso{
Other agg_funcs: \code{\link{avg}},
  \code{\link{countDistinct}}, \code{\link{count}},
  \code{\link{first}}, \code{\link{kurtosis}},
  \code{\link{last}}, \code{\link{max}},
  \code{\link{mean}}, \code{\link{min}}, \code{\link{sd}},
  \code{\link{skewness}}, \code{\link{stddev_pop}},
  \code{\link{stddev_samp}}, \code{\link{sumDistinct}},
  \code{\link{sum}}, \code{\link{var_pop}},
  \code{\link{var_samp}}, \code{\link{var}}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{arrange}}, \code{\link{as.data.frame}},
  \code{\link{attach}}, \code{\link{cache}},
  \code{\link{coalesce}}, \code{\link{collect}},
  \code{\link{colnames}}, \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{rbind}}, \code{\link{registerTempTable}},
  \code{\link{rename}}, \code{\link{repartition}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{take}}, \code{\link{union}},
  \code{\link{unpersist}}, \code{\link{withColumn}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.text}}
}
