% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HJ_Biplot.R
\name{HJBiplot}
\alias{HJBiplot}
\title{HJ Biplot}
\usage{
HJBiplot (X, transform_data = 'scale', ind_name=FALSE,
    vec_name = TRUE)
}
\arguments{
\item{X}{array_like; \cr
A data frame which provides the data to be analyzed. All the variables must be numeric.}

\item{transform_data}{character; \cr
A value indicating whether the columns of X (variables) should be centered or scaled. Options are: "center" that removes the columns means and "scale" that removes the columns means and divide by its standard deviation. For default is "scale".}

\item{ind_name}{bool; \cr
If it is TRUE it prints the name for each row of X. If it is FALSE (default) does not print the names.}

\item{vec_name}{bool; \cr
If it is TRUE (default) it prints the name for each column of X. If it FALSE does not print the names.}
}
\value{
\code{HJBiplot} returns a list containing the following components:
\item{loadings}{  array_like; \cr
          the loadings of the principal components.
          }

\item{coord_ind}{  array_like; \cr
          matrix with the coordinates of individuals.
          }

\item{coord_var}{  array_like; \cr
          matrix with the coordinates of variables.
          }

\item{eigenvalues}{  array_like; \cr
          vector with the eigenvalues.
          }

\item{explvar}{  array_like; \cr
          an vector containing the proportion of variance explained by the first 1, 2,.,k principal components obtained.
          }
}
\description{
This function performs the representation of HJ Biplot (Galindo, 1986).
}
\details{
Algorithm used to construct the HJ Biplot. The Biplot is obtained as result of the configuration of markers for individuals and markers for variables in a reference system defined by the factorial axes resulting from the Decomposition in Singular Values (DVS).
}
\examples{
 data(mtcars)
 HJBiplot(mtcars, transform_data = 'scale', ind_name  = TRUE)

}
\references{
\itemize{
 \item Gabriel, K. R. (1971). The Biplot graphic display of matrices with applications to principal components analysis. Biometrika, 58(3), 453-467.
 \item Galindo, M. P. (1986). Una alternativa de representacion simultanea: HJ-Biplot. Questiio, 10(1), 13-23.
}
}
\author{
Mitzi Cubilla-Montilla, Carlos Torres, Ana Belen Nieto Librero and Purificacion Galindo Villardon
}
