# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Internal function: thin-plane spline matrix
#' @keywords internal
#' @param z A new location matrix
#' @param P A location matrix
#' @param Phi An eigenvector matrix
#' @return A thin-plane spline matrix
#'
tpm2 <- function(z, P, Phi) {
    .Call(`_SpatMCA_tpm2`, z, P, Phi)
}

#' Internal function: M-fold Cross-validation of SpatMCA
#' @keywords internal
#' @param sxr A location matrix for a variable X
#' @param sxr A location matrix for a variable Y
#' @param Yr A data matrix of Y
#' @param Yr A data matrix of X
#' @param M A number of folds
#' @param K The number of estimated eigenfunctions
#' @param tau1ur A range of tau1u
#' @param tau2ur A range of tau2u
#' @param tau1vr A range of tau1v
#' @param tau2vr A range of tau2v
#' @param nkr A vector of fold numbers
#' @param maxit A maximum number of iteration
#' @param tol A tolerance rate
#' @param l2ur A given tau2u
#' @param l2vr A given tau2v
#' @return A list of selected parameters
spatmcacv_rcpp <- function(sxr, syr, Xr, Yr, M, K, tau1ur, tau2ur, tau1vr, tau2vr, nkr, maxit, tol, l2ur, l2vr) {
    .Call(`_SpatMCA_spatmcacv_rcpp`, sxr, syr, Xr, Yr, M, K, tau1ur, tau2ur, tau1vr, tau2vr, nkr, maxit, tol, l2ur, l2vr)
}

#' Internal function: Overall M-fold Cross-validation of SpatMCA
#' @keywords internal
#' @param sxr A location matrix for a variable X
#' @param sxr A location matrix for a variable Y
#' @param Yr A data matrix of Y
#' @param Yr A data matrix of X
#' @param M A number of folds
#' @param K The number of estimated eigenfunctions
#' @param tau1ur A range of tau1u
#' @param tau2ur A range of tau2u
#' @param tau1vr A range of tau1v
#' @param tau2vr A range of tau2v
#' @param nkr A vector of fold numbers
#' @param maxit A maximum number of iteration
#' @param tol A tolerance rate
#' @param l2ur A given tau2u
#' @param l2vr A given tau2v
#' @return A list of selected parameters
spatmcacvall_rcpp <- function(sxr, syr, Xr, Yr, M, K, tau1ur, tau2ur, tau1vr, tau2vr, nkr, maxit, tol, l2ur, l2vr) {
    .Call(`_SpatMCA_spatmcacvall_rcpp`, sxr, syr, Xr, Yr, M, K, tau1ur, tau2ur, tau1vr, tau2vr, nkr, maxit, tol, l2ur, l2vr)
}

