# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Thin-plane spline matrix
#' 
#' @description Produce a thin-plane spline matrix based on a given location matrix
#' 
#' @param location A location matrix
#' @return A thin-plane spline matrix
#' @examples
#' pesudo_sequence <- seq(-5, 5, length = 5)
#' two_dim_location <- as.matrix(expand.grid(x = pesudo_sequence, y = pesudo_sequence))
#' thin_plate_matrix <- thinPlateSplineMatrix(two_dim_location)
thinPlateSplineMatrix <- function(location) {
    .Call(`_SpatPCA_thinPlateSplineMatrix`, location)
}

#' @title Interpolated Eigen-function
#' 
#' @description Produce Eigen-function values based on new locations
#' 
#' @keywords internal
#' @param new_location A location matrix
#' @param original_location A location matrix
#' @param Phi An eigenvector matrix
#' @return A predictive estimate matrix
#' @examples
#' pesudo_sequence <- seq(-5, 5, length = 2)
#' original_location <- as.matrix(expand.grid(x = pesudo_sequence, y = pesudo_sequence))
#' new_location <- matrix(c(0.1, 0.2), nrow = 1, ncol = 2)
#' Phi <- matrix(c(1, 0, 0, 0), nrow = 4, ncol = 1)
#' thin_plate_matrix <- eigenFunction(new_location, original_location, Phi)
eigenFunction <- function(new_location, original_location, Phi) {
    .Call(`_SpatPCA_eigenFunction`, new_location, original_location, Phi)
}

#' Internal function: M-fold Cross-validation 
#' @keywords internal
#' @param sxyr A location matrix
#' @param Yr A data matrix
#' @param M The number of folds for CV
#' @param K The number of estimated eigen-functions
#' @param tau1r A range of tau1
#' @param tau2r A range of tau2
#' @param gammar A range of gamma
#' @param nkr A vector of fold numbers
#' @param maxit A maximum number of iteration
#' @param tol A tolerance rate
#' @param l2r A given tau2
#' @return A list of selected parameters
spatpcaCV <- function(sxyr, Yr, M, K, tau1r, tau2r, gammar, nkr, maxit, tol, l2r) {
    .Call(`_SpatPCA_spatpcaCV`, sxyr, Yr, M, K, tau1r, tau2r, gammar, nkr, maxit, tol, l2r)
}

#' Internal function: Spatial prediction
#' @keywords internal
#' @param phir A matrix of estimated eigenfunctions based on original locations
#' @param Yr A data matrix
#' @param gamma A gamma value
#' @param predicted_eignefunction A vector of values of an eigenfunction on new locations
#' @return A list of objects
#' \item{prediction}{A vector of spatial predictions}
#' \item{estimated_covariance}{An estimated covariance matrix.}
#' \item{eigenvalue}{A vector of estimated eigenvalues.}
#' \item{error}{Error rate for the ADMM algorithm}
spatialPrediction <- function(phir, Yr, gamma, predicted_eignefunction) {
    .Call(`_SpatPCA_spatialPrediction`, phir, Yr, gamma, predicted_eignefunction)
}

