% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{saveRDS}
\alias{saveRDS}
\alias{saveRDS,saveRDS-method}
\alias{saveRDS,DeconvDLModel-method}
\alias{saveRDS,SpatialDDLS-method}
\title{Save \code{\link[SpatialExperiment]{SpatialExperiment}} objects as RDS files}
\usage{
saveRDS(
  object,
  file,
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL
)

\S4method{saveRDS}{DeconvDLModel}(
  object,
  file,
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL
)

\S4method{saveRDS}{SpatialDDLS}(
  object,
  file,
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL
)
}
\arguments{
\item{object}{\code{\link[SpatialExperiment]{SpatialExperiment}} or
\code{\linkS4class{DeconvDLModel}} object to be saved}

\item{file}{File path where the object will be saved}

\item{ascii}{a logical.  If \code{TRUE} or \code{NA}, an ASCII
    representation is written; otherwise (default), a binary one is used.
    See the comments in the help for \code{\link[base]{save}}.}

\item{version}{the workspace format version to use.  \code{NULL}
    specifies the current default version (3). The only other supported
    value is 2, the default from \R 1.4.0 to \R 3.5.0.}

\item{compress}{a logical specifying whether saving to a named file is
    to use \code{"gzip"} compression, or one of \code{"gzip"},
    \code{"bzip2"} or \code{"xz"} to indicate the type of compression to
    be used.  Ignored if \code{file} is a connection.}

\item{refhook}{a hook function for handling reference objects.}
}
\value{
No return value, saves a
\code{\link[SpatialExperiment]{SpatialExperiment}} object as an RDS file on
disk.
}
\description{
Save \code{\link[SpatialExperiment]{SpatialExperiment}} and
\code{\linkS4class{DeconvDLModel}} objects as RDS files. \pkg{keras} models
cannot be stored natively as R objects (e.g. RData or RDS files). By saving
the architecture as a JSON-like character object and the weights as a list,
it is possible to retrieve a functional model and make new predictions. If
the \code{trained.model} slot is empty, the function will behave as usual.
\strong{Note:} with this option, the state of optimizer is not saved, only
model's architecture and weights. It is possible to save the entire model as
an HDF5 file with the \code{\link{saveTrainedModelAsH5}} function and load it
into a \code{\link[SpatialExperiment]{SpatialExperiment}} object with the
\code{\link{loadTrainedModelFromH5}} function. See documentation for details.
}
\seealso{
\code{\link[SpatialExperiment]{SpatialExperiment}}
\code{\link{saveTrainedModelAsH5}}
}
