% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_data_bounds.R
\name{softening.by.data.range}
\alias{softening.by.data.range}
\title{Make split softening based on data ranges.}
\usage{
softening.by.data.range(tr, ds, factor = 1)
}
\arguments{
\item{tr}{The soft tree}

\item{ds}{The data set to be used for determining data boundaries}

\item{factor}{The scalar factor}
}
\value{
The soft tree with the new softening parameters
}
\description{
This softening configures each softening parameter in the tree
according to `data ranges' appropriate to tree nodes.
The parameters are configured such that in each node the distance of the boundary of the softened area from split value is
\code{factor} * the distance from the split value to the furthest data point in the tree node
projected to the direction from the split value to the boundary.
}
\examples{

if(require(tree)) {
  train.data <- iris[c(TRUE,FALSE),]
  test.data <- iris[c(FALSE,TRUE),]
  tr <- tree( Species~., train.data )
  
  # tree with "zero softening"
  s0 <- softsplits( tr )
  # softened tree
  s1 <- softening.by.data.range( s0, train.data, .5 )
  
  response0 <- predictSoftsplits( s0, test.data )
  response1 <- predictSoftsplits( s1, test.data )
  # get class with the highest response
  classification0 <- levels(train.data$Species)[apply( response0, 1, which.max )]
  classification1 <- levels(train.data$Species)[apply( response1, 1, which.max )]
  
  # compare classifiction to the labels
  table( classification0, test.data$Species )
  table( classification1, test.data$Species )
}


}
