/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String replaceCharAt(String string, int pos, char ch) {
        return string.substring(0, pos) + ch + string.substring(pos + 1);
    }

    public static String replace(String string, int start, int end, String replacement) {
        if (end > string.length()) {
            return string.substring(0, start) + replacement;
        }
        return string.substring(0, start) + replacement + string.substring(end);
    }

    public static String replaceAll(String result, String search, String replace) {
        int pos = 0;
        while ((pos = result.indexOf(search, pos)) != -1) {
            result = StringUtils.replace(result, pos, pos + search.length(), replace);
            pos += replace.length();
        }
        return result;
    }

    public static List<Token> tokenizeSql(String sql) {
        int cursor;
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        boolean commentType1 = false;
        boolean commentType2 = false;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        for (cursor = 0; cursor < sql.length(); ++cursor) {
            Token token;
            char ch = sql.charAt(cursor);
            if (commentType1) {
                if (ch != '\n') continue;
                commentType1 = false;
                start = cursor + 1;
                continue;
            }
            if (commentType2) {
                if (ch != '/' || cursor <= 0 || sql.charAt(cursor - 1) != '*') continue;
                commentType2 = false;
                start = cursor + 1;
                continue;
            }
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '@') continue;
            if (cursor > start) {
                token = new Token();
                token.start = start;
                token.end = cursor;
                token.text = sql.substring(start, cursor);
                token.inQuotes = inSingleQuotes || inDoubleQuotes;
                tokens.add(token);
            }
            if (!(ch != '-' || cursor >= sql.length() || sql.charAt(cursor + 1) != '-' || sql.length() - cursor >= 6 && sql.substring(cursor + 2, cursor + 6).equals("hint"))) {
                commentType1 = true;
            } else if (ch == '/' && cursor < sql.length() && sql.charAt(cursor + 1) == '*') {
                commentType2 = true;
            } else if (!Character.isWhitespace(ch)) {
                token = new Token();
                token.start = cursor;
                token.end = cursor + 1;
                token.text = sql.substring(cursor, cursor + 1);
                token.inQuotes = inSingleQuotes || inDoubleQuotes;
                tokens.add(token);
                if (ch == '\'' && !inDoubleQuotes) {
                    boolean bl = inSingleQuotes = !inSingleQuotes;
                }
                if (ch == '\"' && !inSingleQuotes) {
                    inDoubleQuotes = !inDoubleQuotes;
                }
            }
            start = cursor + 1;
        }
        if (cursor > start && !commentType1 && !commentType2) {
            Token token = new Token();
            token.start = start;
            token.end = cursor;
            token.text = sql.substring(start, cursor);
            token.inQuotes = inSingleQuotes || inDoubleQuotes;
            tokens.add(token);
        }
        return tokens;
    }

    public static List<String> safeSplit(String string, char delimiter) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        if (string.length() == 0) {
            result.add("");
            return result;
        }
        boolean literal = false;
        boolean escape = false;
        int startpos = 0;
        for (i = 0; i < string.length(); ++i) {
            char currentchar = string.charAt(i);
            if (currentchar == '\"' && !escape) {
                boolean bl = literal = !literal;
            }
            if (!literal && currentchar == delimiter && !escape) {
                result.add(string.substring(startpos, i));
                startpos = i + 1;
            }
            escape = currentchar == '\\' ? !escape : false;
        }
        result.add(string.substring(startpos, i));
        return result;
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuilder result = new StringBuilder();
        Iterator<?> iter = s.iterator();
        if (iter.hasNext()) {
            result.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            result.append(delimiter);
            result.append(iter.next().toString());
        }
        return result.toString();
    }

    public static class Token {
        public int start;
        public int end;
        public String text;
        public boolean inQuotes = false;

        public Token(Token other) {
            this.start = other.start;
            this.end = other.end;
            this.text = other.text;
        }

        public Token() {
        }

        public boolean isIdentifier() {
            for (int i = 0; i < this.text.length(); ++i) {
                char ch = this.text.charAt(i);
                if (Character.isLetterOrDigit(ch) || ch == '_') continue;
                return false;
            }
            return true;
        }
    }
}

