% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_functions.R
\name{sim.partial.data.from.priors.for.mod.selection}
\alias{sim.partial.data.from.priors.for.mod.selection}
\title{Simulate partial data from priors for doing model selection}
\usage{
sim.partial.data.from.priors.for.mod.selection(geno.matrix, coes.prior,
  sigs.prior, mods.to.sim, d.true, d.range, d.adj.max, w.wt, wts, outpath,
  n.samps.per.mod, coe.sim.model = "identical", coe.dist.par = NA,
  print.interval)
}
\arguments{
\item{geno.matrix}{Matrix specifying which genotypes to simulate}

\item{coes.prior}{A vector with the lower and upper bounds on the coefficients}

\item{sigs.prior}{Range for uniform prior on sigma}

\item{mods.to.sim}{Models to simulate under. Vector with model names of the form c("stick", "mult", "add").}

\item{d.true}{True value of d.}

\item{d.range}{Range of possible values for d. If estimate is outside this, estimate is not considered valid.}

\item{d.adj.max}{Factor to increase observed distant to max fitness by for ad hoc d estimate (when other estimators fail)}

\item{w.wt}{Wild type fitness.}

\item{wts}{Weights when estimating coefficients and d.}

\item{outpath}{Full path including file name to write results}

\item{n.samps.per.mod}{Number of datasets to simulate per model}

\item{coe.sim.model}{Coefficient simulation model. See details.}

\item{coe.dist.par}{Coefficient distribution parameter. If coe.sim.model=="uniform", then uniform is U(-coe.dist.par, +coe.dist.parm).
If coe.sim.model=="normal", then distributed normal with mean given by coe.v and sigma give by coe.dist.parm.}

\item{print.interval}{Every this many replicates, prints out replicate number. If NA (default) no printing is done.}
}
\value{
Nothing. Instead results are written to \code{outpath} file for later analysis
}
\description{
Simulate partial data from priors for doing model selection
}
\details{
This function generates datasets by drawing from priors. It generates \code{n.samps.per.mod}
per model. It then analyzes each dataset under all three models writes one row of summary statistics
to the output file (defined by \code{outpath}).
\code{coe.sim.model}: The expected coefficient is sampled from uniform prior (coes.prior): E[coe]
The coe.sim.model determines how the individual coefficients are generated.
 Possible values: "identical" means all coefficients take same value--E[coe].
"uniform" indicates to  sample individual coefficients from a uniform distribution: U(E[coe]-coe.dist.par, E[coe]+coe.dist.parm).
"normal" means sample coefficients from normal distribution with mean E[coe] and sigma given by coe.dist.par.
Default = "identical".
}

