% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_general_param_xml.R
\name{gen_general_param_xml}
\alias{gen_general_param_xml}
\title{Generate STICS general parameters xml file(s) from a template
file according to a STICS version}
\usage{
gen_general_param_xml(out_dir, stics_version = "latest", overwrite = FALSE)
}
\arguments{
\item{out_dir}{Path of the directory where to generate the file(s).}

\item{stics_version}{Name of the STICS version. Optional, the latest one
is used as default}

\item{overwrite}{Optional logical, TRUE for overwriting files,
FALSE otherwise (default)}
}
\value{
None
}
\description{
Generate STICS general parameters xml file(s) from a template
file according to a STICS version
}
\details{
Please see \code{get_stics_versions_compat()} for the full list of
STICS versions that can be used for the argument \code{stics_version}.
}
\examples{
gen_general_param_xml(out_dir = tempdir())

gen_general_param_xml(out_dir = tempdir(),
                      stics_version = "V10.0",
                      overwrite = TRUE)

}
