% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_causal_forest.R
\name{predict.ple_causal_forest}
\alias{predict.ple_causal_forest}
\title{Predict Patient-level Estimates: Causal Forest}
\usage{
\method{predict}{ple_causal_forest}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained random forest (ranger) model(s).}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-frame with predictions of (E(Y|X,1), E(Y|X,0), E(Y|X,1)-E(Y|X,0))
}
\description{
Get estimates of (E(Y|X,A=1), E(Y|X,A=0), E(Y|X,A=1)-E(Y|X,A=0)) using trained
regression_forest and causal_forest model(s).
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

\donttest{
mod1 = ple_causal_forest(Y, A, X, Xtest=X)
summary(mod1$mu_train)
summary(predict(mod1)) # Training set predictions (oob) #
summary(predict(mod1, newdata=X)) # Test data, no oob #
}

}
