% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_lmtree.R
\name{submod_lmtree}
\alias{submod_lmtree}
\title{Subgroup Identification: Model-based partitioning (lmtree)}
\usage{
submod_lmtree(Y, A, X, Xtest, mu_train, alpha = 0.05,
  minsize = floor(dim(X)[1] * 0.1), maxdepth = 4, parm = NULL, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models)}

\item{alpha}{Significance level for variable selection (default=0.05)}

\item{minsize}{Minimum number of observations in a tree node.
Default = floor( dim(train)[1]*0.05  )}

\item{maxdepth}{Maximum depth of any node in the tree (default=4)}

\item{parm}{Model parameters included in parameter instability tests 
(default=NULL, all parameters)}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained lmtree model.
 \itemize{
  \item mod - lmtree model object
}
}
\description{
Uses the lmtree (model-based partitioning, OLS) algorithm to identify subgroups
(Zeileis, Hothorn, Hornik 2008). Usable for continuous and binary outcomes.
}
\examples{

\donttest{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A
train = data.frame(Y, A, X)
# Outcome/treatment must be labeled as Y/A #

res_lmtree1 = submod_lmtree(Y, A, X, Xtest=X)
res_lmtree2 = submod_lmtree(Y, A, X, Xtest=X, maxdepth=2, minsize=100)
plot(res_lmtree1$mod)
plot(res_lmtree2$mod)
}

}
