% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{osod}
\alias{osod}
\title{One-step One Decision sampling method}
\usage{
osod(pikr, full = FALSE)
}
\arguments{
\item{pikr}{A vector of inclusion probabilities.}

\item{full}{An optional boolean value, to specify whether the full population (the entire vector) is used to update inclusion probabilities. Default: FALSE}
}
\value{
A vector with elements equal to 0 or 1. The value 1 indicates that the unit is selected while the value 0 is for rejected units.
}
\description{
This function implements the One-step One Decision method. It can be used using equal or unequal inclusion probabilities. The method is particularly useful for selecting a sample from a stream.
}
\details{
The method sequentially transforms the vector of inclusion probabilities into a sample whose values are equal to 0 or 1. The method respects the inclusion probabilities and can
handle equal or unequal inclusion probabilities.

The method does not take into account the whole vector of inclusion probabilities by having a sequential implementation. This means that the method is fast and can be implemented in a flow.
}
\examples{

N <- 1000
n <- 100
pik <- inclprob(runif(N),n)
s <- osod(pik)

}
\seealso{
\code{\link{c_bound}}
}
\author{
Raphael Jauslin \email{raphael.jauslin@unine.ch}
}
