% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{prim.cv}
\alias{prim.cv}
\title{Cross-validation for PRIM}
\usage{
prim.cv(data, yvar, censorvar, trtvar, trtref = NULL, xvars, type, des.res,
  alpha = c(0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.2, 0.3, 0.4, 0.5),
  min.sigp.prcnt = 0.2, training.percent = 0.5, n.boot = 0,
  pre.filter = NULL, filter.method = NULL, k.fold = 5, cv.iter = 50,
  max.iter = 500)
}
\arguments{
\item{data}{the input data frame}

\item{yvar}{name for response variable}

\item{censorvar}{name for censoring (1: event; 0: censor), default = NULL}

\item{trtvar}{name for treatment variable, default = NULL (prognostic signature)}

\item{trtref}{coding (in the column of trtvar) for treatment arm}

\item{xvars}{vector of variable names for predictors (covariates)}

\item{type}{type of response variable: "c" continuous (default); "s" survival; "b" binary}

\item{des.res}{the desired response. "larger": prefer larger response (default) "smaller": prefer smaller response}

\item{alpha}{a parameter controlling the number of patients in consideration}

\item{min.sigp.prcnt}{desired proportion of signature positive group size for a given cutoff.}

\item{training.percent}{percentage of subjects in the initial training data}

\item{n.boot}{number of bootstrap for the variable selection procedure for PRIM}

\item{pre.filter}{NULL, no prefiltering conducted;"opt", optimized number of predictors selected; An integer: min(opt, integer) of predictors selected}

\item{filter.method}{NULL, no prefiltering, "univariate", univaraite filtering; "glmnet", glmnet filtering, "unicart": univariate rpart filtering for prognostic case}

\item{k.fold}{number of folds for CV.}

\item{cv.iter}{Algorithm terminates after cv.iter successful iterations of cross-validation}

\item{max.iter}{total number of iterations allowed (including unsuccessful ones)}
}
\value{
a list containing with following entries: 
\item{stats.summary}{Summary of performance statistics.}
\item{pred.classes}{Data frame containing the predictive clases (TRUE/FALSE) for each iteration.}
\item{folds}{Data frame containing the fold indices (index of the fold for each row) for each iteration.}
\item{sig.list}{List of length cv.iter * k.fold containing the signature generated at each of the  k folds, for all iterations.}
\item{error.log}{List of any error messages that are returned at an iteration.}
\item{interplot}{Treatment*subgroup interaction plot for predictive case}
}
\description{
Cross-validation for PRIM
}
