% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Toep-mult.R
\name{toep.mult}
\alias{toep.mult}
\title{Toeplitz matrix multiplication.}
\usage{
toep.mult(acf, X)
}
\arguments{
\item{acf}{Length-\code{N} vector giving the first column (or row) of the Toeplitz matrix.}

\item{X}{Vector or matrix of compatible dimensions with \code{acf}.}
}
\value{
An \code{N}-row matrix corresponding to \code{toeplitz(acf) \%*\% X}.
}
\description{
Efficient matrix multiplication with Toeplitz matrix and arbitrary matrix or vector.
}
\examples{
N <- 20
d <- 3
acf <- exp(-(1:N))
X <- matrix(rnorm(N*d), N, d)
toep.mult(acf, X)
}
