% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalToeplitz.R
\name{NormalToeplitz}
\alias{NormalToeplitz}
\title{Multivariate normal with Toeplitz variance matrix.}
\description{
Provides methods for the Normal-Toeplitz (NTz) distribution defined as\preformatted{z ~ NTz(acf)   <=>   z ~ Normal(0, toeplitz(acf)),
}

i.e., for a multivariate normal with mean zero and variance \code{Tz = toeplitz(acf)}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{NormalToeplitz$new()}}
\item \href{#method-size}{\code{NormalToeplitz$size()}}
\item \href{#method-logdens}{\code{NormalToeplitz$logdens()}}
\item \href{#method-grad}{\code{NormalToeplitz$grad()}}
\item \href{#method-hess}{\code{NormalToeplitz$hess()}}
\item \href{#method-grad_full}{\code{NormalToeplitz$grad_full()}}
\item \href{#method-clone}{\code{NormalToeplitz$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalToeplitz$new(N)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{Size of the NTz random vector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NormalToeplitz} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
Get the size of the NTz random vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalToeplitz$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Size of the NTz random vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logdens"></a>}}
\if{latex}{\out{\hypertarget{method-logdens}{}}}
\subsection{Method \code{logdens()}}{
Log-density function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalToeplitz$logdens(z, acf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument. A vector of length \code{N} or an \verb{N x n_obs} matrix where each column is an \code{N}-dimensional observation.}

\item{\code{acf}}{A vector of length \code{N} containing the autocorrelation (i.e., first row/column) of the Toeplitz variance matrix.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A scalar or vector of length \code{n_obs} containing the log-density of the NTz evaluated at its arguments.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-grad"></a>}}
\if{latex}{\out{\hypertarget{method-grad}{}}}
\subsection{Method \code{grad()}}{
Gradient of the log-density with respect to parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalToeplitz$grad(z, dz, acf, dacf, full_out = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument.  A vector of length \code{N}.}

\item{\code{dz}}{An \verb{N x n_theta} matrix containing the gradient \code{dz/dtheta}.}

\item{\code{acf}}{A vector of length \code{N} containing the autocorrelation of the Toeplitz variance matrix.}

\item{\code{dacf}}{An \verb{N x n_theta} matrix containing the gradient \code{dacf/dtheta}.}

\item{\code{full_out}}{If \code{TRUE}, returns the log-density as well (see 'Value').}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of length \code{n_theta} containing the gradient of the NTz log-density with respect to \code{theta}, or a list with elements \code{ldens} and \code{grad} consisting of the log-density and the gradient vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hess"></a>}}
\if{latex}{\out{\hypertarget{method-hess}{}}}
\subsection{Method \code{hess()}}{
Hessian of log-density with respect to parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalToeplitz$hess(z, dz, d2z, acf, dacf, d2acf, full_out = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument.  A vector of length \code{N}.}

\item{\code{dz}}{An \verb{N x n_theta} matrix containing the gradient \code{dz/dtheta}.}

\item{\code{d2z}}{An \verb{N x n_theta x n_theta} array containing the Hessian \verb{d^2z/dtheta^2}.}

\item{\code{acf}}{A vector of length \code{N} containing the autocorrelation of the Toeplitz variance matrix.}

\item{\code{dacf}}{An \verb{N x n_theta} matrix containing the gradient \code{dacf/dtheta}.}

\item{\code{d2acf}}{An \verb{N x n_theta x n_theta} array containing the Hessian \code{dacf^2/dtheta^2}.}

\item{\code{full_out}}{If \code{TRUE}, returns the log-density and its gradient as well (see 'Value').}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \verb{n_theta x n_theta} matrix containing the Hessian of the NTz log-density with respect to \code{theta}, or a list with elements \code{ldens}, \code{grad}, and \code{hess} consisting of the log-density, its gradient (a vector of size \code{n_theta}), and the Hessian matrix, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-grad_full"></a>}}
\if{latex}{\out{\hypertarget{method-grad_full}{}}}
\subsection{Method \code{grad_full()}}{
Full gradient of log-density function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalToeplitz$grad_full(z, acf, calc_dldz = TRUE, calc_dlda = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument.  A vector of length \code{N}.}

\item{\code{acf}}{A vector of length \code{N} containing the autocorrelation of the Toeplitz variance matrix.}

\item{\code{calc_dldz}}{Whether or not to calculate the gradient with respect to \code{z}.}

\item{\code{calc_dlda}}{Whether or not to calculate the gradient with respect to \code{acf}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with elements:
\describe{
\item{\code{ldens}}{The log-density evaluated at \code{z} and \code{acf}.}
\item{\code{dldz}}{The length-\code{N} gradient vector with respect to \code{z}, if \code{calc_dldz = TRUE}.}
\item{\code{dlda}}{The length-\code{N} gradient vector with respect to \code{acf}, if \code{calc_dlda = TRUE}.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalToeplitz$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
