% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sra.R
\name{sra}
\alias{sra}
\alias{sra.default}
\alias{sra.matrix}
\alias{sra.list}
\title{Compute the sequential rank agreement}
\usage{
sra(object, B, na.strings, nitems, type, epsilon = 0, ...)

\method{sra}{default}(object, B, na.strings, nitems, type, epsilon = 0, ...)

\method{sra}{matrix}(
  object,
  B = 1,
  na.strings = NULL,
  nitems = nrow(object),
  type = c("sd", "mad"),
  epsilon = 0,
  ...
)

\method{sra}{list}(
  object,
  B = 1,
  na.strings = NULL,
  nitems = max(sapply(object, length)),
  type = c("sd", "mad"),
  epsilon = 0,
  ...
)
}
\arguments{
\item{object}{Either matrix where each column is a ranked list of
items or a list of ranked lists of items. Elements are integers
between 1 and the length of the lists. The lists should have
the same length but censoring can be used by setting the list
to zero from a point onwards. See details for more information.}

\item{B}{An integer giving the number of randomization to sample
over in the case of censored observations}

\item{na.strings}{A vector of strings/values that represent missing
values in addition to NA. Defaults to NULL which means only NA
are censored values.}

\item{nitems}{The total number of items in the original lists if we only have partial lists available.}

\item{type}{The type of measure to use. Either sd (standard
deviation - the default) or mad (median absolute deviance around the median)}

\item{epsilon}{A non-negative numeric vector that contains the minimum limit in proportion of lists that must show the item. Defaults to 0. If a single number is provided then the value will be recycles to the number of items.}

\item{...}{Arguments passed to methods.}
}
\value{
A vector of the sequential rank agreement
}
\description{
Compute the sequential rank agreement
}
\examples{

mlist <- matrix(cbind(1:8,c(1,2,3,5,6,7,4,8),c(1,5,3,4,2,8,7,6)),ncol=3)
sra(mlist)

mlist <- matrix(cbind(1:8,c(1,2,3,5,6,7,4,8),c(1,5,3,4,2,8,7,6)),ncol=3)
sra(mlist, nitems=20, B=10)

alist <- list(a=1:8,b=sample(1:8),c=sample(1:8))
sra(alist)

blist <- list(x1=letters,x2=sample(letters),x3=sample(letters))
sra(blist)

## censored lists are either too short
clist <- list(x1=c("a","b","c","d","e","f","g","h"),
              x2=c("h","c","f","g","b"),
              x3=c("d","e","a"))
set.seed(17)
sra(clist,na.strings="z",B=10)

## or use a special code for missing elements
Clist <- list(x1=c("a","b","c","d","e","f","g","h"),
              x2=c("h","c","f","g","b","z","z","z"),
              x3=c("d","e","a","z","z","z","z","z"))
set.seed(17)
sra(Clist,na.strings="z",B=10)

}
\author{
Claus Ekstrøm <ekstrom@sund.ku.dk> and Thomas A Gerds <tag@biostat.ku.dk>
}
