% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_OrdCont_copula.R
\name{fit_copula_OrdCont}
\alias{fit_copula_OrdCont}
\title{Fit ordinal-continuous vine copula model}
\usage{
fit_copula_OrdCont(
  data,
  copula_family,
  marginal_S0,
  marginal_S1,
  K_T,
  start_copula,
  method = "BFGS",
  ...
)
}
\arguments{
\item{data}{data frame with three columns in the following order: surrogate
endpoint, true endpoint, and treatment indicator (0/1 coding). Ordinal endpoints
should be integers starting from \code{1}.}

\item{copula_family}{One of the following parametric copula families:
\code{"clayton"}, \code{"frank"}, \code{"gaussian"}, or \code{"gumbel"}. The first element in
\code{copula_family} corresponds to the control group, the second to the
experimental group.}

\item{marginal_S0, marginal_S1}{List with the
following three elements (in order):
\itemize{
\item Density function with first argument \code{x} and second argument \code{para} the parameter
vector for this distribution.
\item Distribution function with first argument \code{x} and second argument \code{para} the parameter
vector for this distribution.
\item Inverse distribution function with first argument \code{p} and second argument \code{para} the parameter
vector for this distribution.
\item The number of elements in \code{para}.
\item A vector of starting values for \code{para}.
}}

\item{K_T}{Number of categories in the true endpoint.}

\item{start_copula}{Starting value for the copula parameter.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGS"}.}

\item{...}{
  Arguments passed on to \code{\link[=fit_copula_submodel_OrdCont]{fit_copula_submodel_OrdCont}}
  \describe{
    \item{\code{names_XY}}{Names for \code{X} and \code{Y}, respectively.}
    \item{\code{twostep}}{(boolean) If \code{TRUE}, the starting values are fixed for the
marginal distributions and only the copula parameter is estimated.}
    \item{\code{start_Y}}{Starting values for the marginal distribution paramters for \code{Y}.}
    \item{\code{X}}{First variable (Ordinal with \eqn{K} categories)}
    \item{\code{Y}}{Second variable (Continuous)}
    \item{\code{K}}{Number of categories in \code{X}.}
    \item{\code{marginal_Y}}{List with the following five elements (in order):
\itemize{
\item Density function with first argument \code{x} and second argument \code{para} the parameter
vector for this distribution.
\item Distribution function with first argument \code{x} and second argument \code{para}.
\item Inverse distribution function with first argument \code{p} and second argument \code{para}.
\item The number of elements in \code{para}.
\item Starting values for \code{para}.
}}
  }}
}
\value{
Returns an S3 object that can be used to perform the sensitivity
analysis with \code{\link[=sensitivity_analysis_copula]{sensitivity_analysis_copula()}}.
}
\description{
\code{\link[=fit_copula_OrdCont]{fit_copula_OrdCont()}} fits the ordinal-continuous vine copula model. See
Details for more information about this model.
}
\details{
\subsection{Vine Copula Model for Ordinal Endpoints}{

Following the Neyman-Rubin potential outcomes framework, we assume that each
patient has four potential outcomes, two for each arm, represented by
\eqn{\boldsymbol{Y} = (T_0, S_0, S_1, T_1)'}. Here, \eqn{\boldsymbol{Y_z} =
(S_z, T_z)'} are the potential surrogate and true endpoints under treatment
\eqn{Z = z}. We will further assume that \eqn{T} is ordinal and \eqn{S} is
continuous; consequently, the function argument \code{X} corresponds to \eqn{T} and
\code{Y} to \eqn{S}. (The roles of \eqn{S} and \eqn{T} can be interchanged without
loss of generality.)

We introduce latent variables to model \eqn{\boldsymbol{Y}}. Latent variables
will be denoted by a tilde. For instance, if \eqn{T_z} is ordinal with \eqn{K_T}
categories, then \eqn{T_z} is a function of the latent
\eqn{\tilde{T}_z \sim N(0, 1)} as follows:
\deqn{
T_z = g_{T_z}(\tilde{T}_z; \boldsymbol{c}^{T_z}) = \begin{cases}
1 & \text{ if } -\infty = c_0^{T_z} < \tilde{T_z} \le c_1^{T_z} \\
\vdots \\
k & \text{ if } c_{k - 1}^{T_z} < \tilde{T_z} \le c_k^{T_z} \\
\vdots \\
K & \text{ if } c_{K_{T} - 1}^{T_z} < \tilde{T_z} \le c_{K_{T}}^{T_z} = \infty, \\
\end{cases}
}
where \eqn{\boldsymbol{c}^{T_z} = (c_1^{T_z}, \cdots, c_{K_T - 1}^{T_z})}.
The latent counterpart of \eqn{\boldsymbol{Y}} is again denoted by a tilde;
for example, \eqn{\tilde{\boldsymbol{Y}} = (\tilde{T}_0, S_0, S_1, \tilde{T}_1)'}
if \eqn{T_z} is ordinal and \eqn{S_z} is continuous.

The vector of latent potential outcome \eqn{\tilde{\boldsymbol{Y}}} is modeled
with a D-vine copula as follows:
\deqn{
f_{\tilde{\boldsymbol{Y}}} =  f_{\tilde{T}_0} \, f_{S_0} \, f_{S_1} \, f_{\tilde{T}_1}
\cdot c_{\tilde{T}_0, S_0 } \, c_{S_0, S_1} \, c_{S_1, \tilde{T}_1}
\cdot c_{\tilde{T}_0, S_1; S_0} \, c_{S_0, \tilde{T}_1; S_1}
\cdot c_{\tilde{T}_0, \tilde{T}_1; S_0, S_1},
}
where (i) \eqn{f_{T_0}}, \eqn{f_{S_0}}, \eqn{f_{S_1}}, and \eqn{f_{T_1}} are
univariate density functions, (ii) \eqn{c_{T_0, S_0}}, \eqn{c_{S_0, S_1}},
and \eqn{c_{S_1, T_1}} are unconditional bivariate copula densities, and (iii)
\eqn{c_{T_0, S_1; S_0}}, \eqn{c_{S_0, T_1; S_1}}, and \eqn{c_{T_0, T_1; S_0, S_1}}
are conditional bivariate copula densities (e.g., \eqn{c_{T_0, S_1; S_0}}
is the copula density of \eqn{(T_0, S_1)' \mid S_0}. We also make the
simplifying assumption for all copulas.
}

\subsection{Observed-Data Likelihood}{

In practice, we only observe \eqn{(S_0, T_0)'} or \eqn{(S_1, T_1)'}. Hence, to
estimate the (identifiable) parameters of the D-vine copula model, we need
to derive the observed-data likelihood. The observed-data loglikelihood for
\eqn{(S_z, T_z)'} is as follows:
\deqn{
f_{\boldsymbol{Y_z}}(s, t; \boldsymbol{\beta}) =
\int_{c^{T_z}_{t - 1}}^{+ \infty} f_{\boldsymbol{\tilde{Y}_z}}(s, x; \boldsymbol{\beta}) \, dx - \int_{c^{T_z}_{t}}^{+ \infty} f_{\boldsymbol{\tilde{Y}_z}}(s, x; \boldsymbol{\beta}) \, dx.
}
The above expression is used in \code{\link[=ordinal_continuous_loglik]{ordinal_continuous_loglik()}} to compute the
loglikelihood for the observed values for \eqn{Z = 0} or \eqn{Z = 1}. In this
function, \code{X} and \code{Y} correspond to \eqn{T_z} and \eqn{S_z} if \eqn{T_z} is
ordinal and \eqn{S_z} continuous. Otherwise, \code{X} and \code{Y} correspond to
\eqn{S_z} and \eqn{T_z}.
}
}
\seealso{
\code{\link[=sensitivity_analysis_copula]{sensitivity_analysis_copula()}}, \code{\link[=print.vine_copula_fit]{print.vine_copula_fit()}},
\code{\link[=plot.vine_copula_fit]{plot.vine_copula_fit()}}
}
\author{
Florian Stijven
}
