% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_OrdCont_copula.R
\name{ordinal_continuous_loglik}
\alias{ordinal_continuous_loglik}
\title{Loglikelihood function for ordinal-continuous copula model}
\usage{
ordinal_continuous_loglik(
  para,
  X,
  Y,
  copula_family,
  marginal_Y,
  K,
  return_sum = TRUE
)
}
\arguments{
\item{para}{Parameter vector. The parameters are ordered as follows:
\itemize{
\item \code{para[1:p1]}: Cutpoints for the latent distribution of X corresponding to
\eqn{c_1, \dots, c_{K - 1}} (see Details).
\item \code{para[(p1 + 1):(p1 + p2)]}: Parameters for surrogate distribution, more details in
\code{?Surrogate::cdf_fun} for the specific implementations.
\item \code{para[p1 + p2 + 1]}: copula parameter
}}

\item{X}{First variable (Ordinal with \eqn{K} categories)}

\item{Y}{Second variable (Continuous)}

\item{copula_family}{Copula family, one of the following:
\itemize{
\item \code{"clayton"}
\item \code{"frank"}
\item \code{"gumbel"}
\item \code{"gaussian"}
}}

\item{marginal_Y}{List with the following five elements (in order):
\itemize{
\item Density function with first argument \code{x} and second argument \code{para} the parameter
vector for this distribution.
\item Distribution function with first argument \code{x} and second argument \code{para}.
\item Inverse distribution function with first argument \code{p} and second argument \code{para}.
\item The number of elements in \code{para}.
\item Starting values for \code{para}.
}}

\item{K}{Number of categories in \code{X}.}

\item{return_sum}{Return the sum of the individual loglikelihoods? If \code{FALSE},
a vector with the individual loglikelihood contributions is returned.}
}
\value{
(numeric) loglikelihood value evaluated in \code{para}.
}
\description{
\code{\link[=ordinal_continuous_loglik]{ordinal_continuous_loglik()}} computes the observed-data loglikelihood for a
bivariate copula model with a continuous and an ordinal endpoint. The model
is based on a latent variable representation of the ordinal endpoint.
}
\details{
\subsection{Vine Copula Model for Ordinal Endpoints}{

Following the Neyman-Rubin potential outcomes framework, we assume that each
patient has four potential outcomes, two for each arm, represented by
\eqn{\boldsymbol{Y} = (T_0, S_0, S_1, T_1)'}. Here, \eqn{\boldsymbol{Y_z} =
(S_z, T_z)'} are the potential surrogate and true endpoints under treatment
\eqn{Z = z}. We will further assume that \eqn{T} is ordinal and \eqn{S} is
continuous; consequently, the function argument \code{X} corresponds to \eqn{T} and
\code{Y} to \eqn{S}. (The roles of \eqn{S} and \eqn{T} can be interchanged without
loss of generality.)

We introduce latent variables to model \eqn{\boldsymbol{Y}}. Latent variables
will be denoted by a tilde. For instance, if \eqn{T_z} is ordinal with \eqn{K_T}
categories, then \eqn{T_z} is a function of the latent
\eqn{\tilde{T}_z \sim N(0, 1)} as follows:
\deqn{
T_z = g_{T_z}(\tilde{T}_z; \boldsymbol{c}^{T_z}) = \begin{cases}
1 & \text{ if } -\infty = c_0^{T_z} < \tilde{T_z} \le c_1^{T_z} \\
\vdots \\
k & \text{ if } c_{k - 1}^{T_z} < \tilde{T_z} \le c_k^{T_z} \\
\vdots \\
K & \text{ if } c_{K_{T} - 1}^{T_z} < \tilde{T_z} \le c_{K_{T}}^{T_z} = \infty, \\
\end{cases}
}
where \eqn{\boldsymbol{c}^{T_z} = (c_1^{T_z}, \cdots, c_{K_T - 1}^{T_z})}.
The latent counterpart of \eqn{\boldsymbol{Y}} is again denoted by a tilde;
for example, \eqn{\tilde{\boldsymbol{Y}} = (\tilde{T}_0, S_0, S_1, \tilde{T}_1)'}
if \eqn{T_z} is ordinal and \eqn{S_z} is continuous.

The vector of latent potential outcome \eqn{\tilde{\boldsymbol{Y}}} is modeled
with a D-vine copula as follows:
\deqn{
f_{\tilde{\boldsymbol{Y}}} =  f_{\tilde{T}_0} \, f_{S_0} \, f_{S_1} \, f_{\tilde{T}_1}
\cdot c_{\tilde{T}_0, S_0 } \, c_{S_0, S_1} \, c_{S_1, \tilde{T}_1}
\cdot c_{\tilde{T}_0, S_1; S_0} \, c_{S_0, \tilde{T}_1; S_1}
\cdot c_{\tilde{T}_0, \tilde{T}_1; S_0, S_1},
}
where (i) \eqn{f_{T_0}}, \eqn{f_{S_0}}, \eqn{f_{S_1}}, and \eqn{f_{T_1}} are
univariate density functions, (ii) \eqn{c_{T_0, S_0}}, \eqn{c_{S_0, S_1}},
and \eqn{c_{S_1, T_1}} are unconditional bivariate copula densities, and (iii)
\eqn{c_{T_0, S_1; S_0}}, \eqn{c_{S_0, T_1; S_1}}, and \eqn{c_{T_0, T_1; S_0, S_1}}
are conditional bivariate copula densities (e.g., \eqn{c_{T_0, S_1; S_0}}
is the copula density of \eqn{(T_0, S_1)' \mid S_0}. We also make the
simplifying assumption for all copulas.
}

\subsection{Observed-Data Likelihood}{

In practice, we only observe \eqn{(S_0, T_0)'} or \eqn{(S_1, T_1)'}. Hence, to
estimate the (identifiable) parameters of the D-vine copula model, we need
to derive the observed-data likelihood. The observed-data loglikelihood for
\eqn{(S_z, T_z)'} is as follows:
\deqn{
f_{\boldsymbol{Y_z}}(s, t; \boldsymbol{\beta}) =
\int_{c^{T_z}_{t - 1}}^{+ \infty} f_{\boldsymbol{\tilde{Y}_z}}(s, x; \boldsymbol{\beta}) \, dx - \int_{c^{T_z}_{t}}^{+ \infty} f_{\boldsymbol{\tilde{Y}_z}}(s, x; \boldsymbol{\beta}) \, dx.
}
The above expression is used in \code{\link[=ordinal_continuous_loglik]{ordinal_continuous_loglik()}} to compute the
loglikelihood for the observed values for \eqn{Z = 0} or \eqn{Z = 1}. In this
function, \code{X} and \code{Y} correspond to \eqn{T_z} and \eqn{S_z} if \eqn{T_z} is
ordinal and \eqn{S_z} continuous. Otherwise, \code{X} and \code{Y} correspond to
\eqn{S_z} and \eqn{T_z}.
}
}
