% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surr_rsq.R
\name{surr_rsq}
\alias{surr_rsq}
\title{A function to calculate the surrogate R-squared measure.}
\usage{
surr_rsq(model, full_model, data, avg.num = 30, ...)
}
\arguments{
\item{model}{A reduced model that needs to be investigated. The reported surrogate R-square is for this reduced model.}

\item{full_model}{A full model that contains all of the predictors in the data set.}

\item{data}{A dataset containing the categorical responses, predictors.}

\item{avg.num}{The number of replication for the averaging of surrogate R-square.}

\item{...}{Additional optional arguments.}
}
\value{
An object of class \code{"surr_rsq"} is a list containing the following components:
\item{\code{surr_rsq}}{the surrogate R-square value;}
\item{\code{reduced_model}}{the reduced model under investigation. It should be a subset
of the full model;}
\item{\code{full_model}}{the full model used for generating the surrogate response. It should
have passed initial variable screening and model diagnostics (see Paper for reference);}
\item{\code{data}}{the dataset contains the response variable and all the predictors.}
}
\description{
It can provide the surrogate R-squared for a user specified model.
This function will generate an S3 object of surrogate R-squared measure that will
be called from other functions of this package. The generic S3 function \code{print}
is also developed to present the surrogate R-squared measure.
}
\examples{
data("RedWine")

full_formula <- as.formula(quality ~ fixed.acidity + volatile.acidity +
citric.acid+ residual.sugar + chlorides + free.sulfur.dioxide +
total.sulfur.dioxide + density + pH + sulphates + alcohol)

full_mod <- polr(formula = full_formula,
data=RedWine, method  = "probit")

select_model <- update(full_mod, formula. = ". ~ . - fixed.acidity -
citric.acid - residual.sugar - density")
surr_obj_sele_mod <- surr_rsq(model = select_model, full_model = full_mod,
                               data = RedWine, avg.num = 30)
print(surr_obj_sele_mod$surr_rsq, digits = 3)

}
\references{
Zhu, X., Liu, D., Lin, Z., Greenwell, B. (2022). SurrogateRsq: an R package for categorical
data goodness-of-fit analysis using the surrogate R-squared
}
